model Ex10_5
Complex If "subtransient fault current";
  Real If_abs(final unit = "per unit") "magnitude of If";
  Modelica.SIunits.Current If1 "fault current in Ampere";
  Complex If_gen "contribution of generator to fault current";
  Complex If_mot "contribution of each motor to fault current";
  Complex If_A "contribution of generator to fault current through breaker A";
  Real If_A_abs(final unit = "per unit") "contribution of each motor to fault current through breaker A";
  Modelica.SIunits.Current If_A1 "contribution of each motor to fault current through breaker A";
  Complex Ifgen_sc "current due to generator contribution";
  Real Ifgen_sc_abs(final unit = "per unit") "magnitude of Ifgen_sc";
  Complex Ifmot "current due to motor contribution";
  Real Ifmot_abs(final unit = "per unit") "magnitude of Ifmot";
  Modelica.SIunits.Current If_sym "symmetrical short circuit current";
  Modelica.SIunits.Current Isc_least "least short circuit current interupting the rating of breaker";
  Modelica.SIunits.Current I_int_b "short circuit interrupting current";
  Complex[2, 2] Ybus "admittance matrix";
  Complex[2, 2] Zbus "impedance matrix";
  Complex Isc "short circuit current";
  Complex V2 "voltage at bus 2 with fault in bus 1";
  Complex If_tr "fault current from transformer";
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 25, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-85, 126}, extent = {{-18, -17}, {18, 17}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 25, V_b = 6.9, kT = 2, r = 0, x = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-30, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0.0, X = 0.5, t1 = 15, t2 = 45) annotation(
    Placement(visible = true, transformation(origin = {68, -84}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = 25, V_0 = 2, V_b = 6.9, Vn = 13.8, ra = 0.001, x1d = 0.15) annotation(
    Placement(visible = true, transformation(origin = {-91, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor1(D = 0, M = 8, Sn = 5, V_0 = 1, V_b = 6.9, Vn = 6.9, ra = 0.001, x1d = 0.2 * (25 / 5)) annotation(
    Placement(visible = true, transformation(origin = {131, 86}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor2(D = 0, M = 8, Sn = 5, V_0 = 1, V_b = 6.9, Vn = 6.9, ra = 0.001, x1d = 0.2 * (25 / 5)) annotation(
    Placement(visible = true, transformation(origin = {127, 36}, extent = {{-10, 10}, {10, -10}}, rotation = 180)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor3(D = 0, M = 8, Sn = 5, V_0 = 1, V_b = 6.9, Vn = 6.9, ra = 0.001, x1d = 0.2 * (25 / 5)) annotation(
    Placement(visible = true, transformation(origin = {130, -12}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 motor4(D = 0, M = 8, Sn = 5, V_0 = 1, V_b = 6.9, Vn = 6.9, ra = 0.001, x1d = 0.2 * (25 / 5)) annotation(
    Placement(visible = true, transformation(origin = {132, -56}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breakerD(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {56, 82}, extent = {{-5, -6}, {5, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breakerC(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {55, 37}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breakerB(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {55, -12}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breakerA(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {52, -57}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker5(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-55, -1}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker6(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-4, 0}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  parameter Complex Zth = Complex(0, motor1.x1d / 4 * (generator1.x1d + twoWindingTransformer1.x) / (motor1.x1d / 4 + generator1.x1d + twoWindingTransformer1.x));
  parameter Real Vf(final unit = "per unit") = 1.0 "fault voltage";
  parameter Modelica.SIunits.Current Ib = SysData.S_b * 1e3 / (generator1.V_b * sqrt(3)) "base current";
  parameter Real X1d_sc(final unit = "per unit") = 1.5 "transient reactance of each motor";
  parameter Complex Zth1 = Complex(0, X1d_sc / 4 * (generator1.x1d + twoWindingTransformer1.x) / (X1d_sc / 4 + generator1.x1d + twoWindingTransformer1.x));
  parameter OpenIPSL.Types.VoltageKilo Vcb_max = 15.5 "circuit breaker rated maximum voltage";
  parameter Modelica.SIunits.Current I_int = 8900 "short circuit interupting current at 15.5 KV";
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.5) annotation(
    Placement(visible = true, transformation(origin = {86, 83}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.5) annotation(
    Placement(visible = true, transformation(origin = {91, 38}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.5) annotation(
    Placement(visible = true, transformation(origin = {92, -12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0, G = 0, R = 0, X = 0.5) annotation(
    Placement(visible = true, transformation(origin = {90, -56}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_b = 6.9, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-68, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_b = 6.9, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {11, 8.88178e-16}, extent = {{-11, -11}, {11, 11}}, rotation = 0)));
equation
  connect(breakerB.s, bus1.p) annotation(
    Line(points = {{49, -12}, {22, -12}, {22, 0}, {11, 0}}, color = {0, 0, 255}));
  connect(breakerA.s, bus1.p) annotation(
    Line(points = {{46, -57}, {21, -57}, {21, 0}, {11, 0}}, color = {0, 0, 255}));
  connect(breakerD.s, bus1.p) annotation(
    Line(points = {{50, 82}, {21, 82}, {21, 0}, {11, 0}}, color = {0, 0, 255}));
  connect(breakerC.s, bus1.p) annotation(
    Line(points = {{49, 37}, {21, 37}, {21, 0}, {11, 0}}, color = {0, 0, 255}));
  connect(breaker6.r, bus1.p) annotation(
    Line(points = {{1, 0}, {11, 0}}, color = {0, 0, 255}));
  connect(motor4.vf, motor4.vf0) annotation(
    Line(points = {{144, -51}, {149, -51}, {149, -36}, {140, -36}, {140, -45}, {140, -45}, {140, -45}}, color = {0, 0, 127}));
  connect(motor4.pm, motor4.pm0) annotation(
    Line(points = {{144, -61}, {150, -61}, {150, -74}, {143, -74}, {143, -67}, {140, -67}, {140, -67}}, color = {0, 0, 127}));
  connect(pwLine4.n, motor4.p) annotation(
    Line(points = {{99, -56}, {122, -56}}, color = {0, 0, 255}));
  connect(pwLine4.p, breakerA.r) annotation(
    Line(points = {{82, -56}, {58, -56}, {58, -57}}, color = {0, 0, 255}));
  connect(pwFault1.p, breakerA.r) annotation(
    Line(points = {{68, -77}, {68, -57}, {58, -57}}, color = {0, 0, 255}));
  connect(breakerD.r, pwLine1.p) annotation(
    Line(points = {{62, 82}, {77, 82}, {77, 83}}, color = {0, 0, 255}));
  connect(breakerC.r, pwLine2.p) annotation(
    Line(points = {{61, 37}, {82, 37}, {82, 38}}, color = {0, 0, 255}));
  connect(breakerB.r, pwLine3.p) annotation(
    Line(points = {{61, -12}, {83, -12}}, color = {0, 0, 255}));
  connect(breaker5.r, twoWindingTransformer1.p) annotation(
    Line(points = {{-50, -1}, {-50, 0}, {-41, 0}}, color = {0, 0, 255}));
  connect(bus2.p, breaker5.s) annotation(
    Line(points = {{-68, 0}, {-57, 0}, {-57, -1}, {-60, -1}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, breaker6.s) annotation(
    Line(points = {{-19, 0}, {-9, 0}}, color = {0, 0, 255}));
  connect(motor1.pm, motor1.pm0) annotation(
    Line(points = {{143, 81}, {147, 81}, {147, 69}, {139, 69}, {139, 76}, {139, 76}, {139, 75}}, color = {0, 0, 127}));
  connect(motor1.vf, motor1.vf0) annotation(
    Line(points = {{143, 91}, {148, 91}, {148, 116}, {135, 116}, {135, 97}, {139, 97}, {139, 97}}, color = {0, 0, 127}));
  connect(pwLine1.n, motor1.p) annotation(
    Line(points = {{95, 83}, {121, 83}, {121, 86}}, color = {0, 0, 255}));
  connect(motor2.pm, motor2.pm0) annotation(
    Line(points = {{139, 31}, {146, 31}, {146, 16}, {141, 16}, {141, 25}, {135, 25}, {135, 25}}, color = {0, 0, 127}));
  connect(motor2.vf, motor2.vf0) annotation(
    Line(points = {{139, 41}, {145, 41}, {145, 54}, {134, 54}, {134, 47}, {135, 47}, {135, 47}}, color = {0, 0, 127}));
  connect(pwLine2.n, motor2.p) annotation(
    Line(points = {{100, 38}, {124, 38}, {124, 36}, {117, 36}}, color = {0, 0, 255}));
  connect(pwLine3.n, motor3.p) annotation(
    Line(points = {{101, -12}, {120, -12}}, color = {0, 0, 255}));
  connect(motor3.vf, motor3.vf0) annotation(
    Line(points = {{142, -7}, {147, -7}, {147, 2}, {137, 2}, {137, 1}, {137, 1}, {137, -1}, {138, -1}}, color = {0, 0, 127}));
  connect(motor3.pm, motor3.pm0) annotation(
    Line(points = {{142, -17}, {149, -17}, {149, -28}, {138, -28}, {138, -22}, {138, -22}, {138, -23}}, color = {0, 0, 127}));
  connect(generator1.p, bus2.p) annotation(
    Line(points = {{-81, 0}, {-70, 0}, {-70, 0}, {-68, 0}}, color = {0, 0, 255}));
  connect(generator1.vf, generator1.vf0) annotation(
    Line(points = {{-103, 5}, {-109, 5}, {-109, 32}, {-99, 32}, {-99, 12}, {-99, 12}, {-99, 11}}, color = {0, 0, 127}));
  connect(generator1.pm, generator1.pm0) annotation(
    Line(points = {{-103, -5}, {-110, -5}, {-110, -28}, {-96, -28}, {-96, -12}, {-99, -12}, {-99, -11}}, color = {0, 0, 127}));
//(a)finding subtransient fault current
  If = Vf / Zth;
  If_abs = sqrt(If.re ^ 2 + If.im ^ 2);
  If1 = If_abs * Ib;
//(b)finding subtransient fault current in breaker A
  If_gen = If * (0.25 / 0.5);
  If_mot = 0.25 * If_gen;
  If_A = If_gen + 3 * If_mot;
  If_A_abs = sqrt(If_A.re ^ 2 + If_A.im ^ 2);
  If_A1 = Ib * If_A_abs;
//(c)finding symmetrical short circuit current
  Ifgen_sc = Vf * (X1d_sc / 4) / (Zth1 * (X1d_sc / 4 + generator1.x1d + twoWindingTransformer1.x));
  Ifgen_sc_abs = sqrt(Ifgen_sc.re ^ 2 + Ifgen_sc.im ^ 2);
  Ifmot = 0.25 * (Vf * (generator1.x1d + twoWindingTransformer1.x) / (Zth1 * (X1d_sc / 4 + generator1.x1d + twoWindingTransformer1.x)));
  Ifmot_abs = sqrt(Ifmot.re ^ 2 + Ifmot.im ^ 2);
  If_sym = (Ifgen_sc_abs + 3 * Ifmot_abs) * Ib;
  Isc_least = (Ifgen_sc_abs + 4 * Ifmot_abs) * Ib;
  I_int_b = Vcb_max * I_int / generator1.V_b;
  Ybus = {{Complex(0, (-1 / twoWindingTransformer1.x) - 4 / X1d_sc), -Complex(0, -1 / twoWindingTransformer1.x)}, {-Complex(0, -1 / twoWindingTransformer1.x), Complex(0, (-1 / twoWindingTransformer1.x) - 1 /generator1.x1d)}};
  Zbus = Complex(0, -Modelica.Math.Matrices.inv(Ybus.im));
  Isc = Vf / Zbus[1, 1];
  V2 = Vf - Isc * Zbus[2, 1];
  If_tr = V2 * Ybus[1, 2].im;
//"The  answer may slightly vary due to  rounding off values"
  annotation(
    Diagram(coordinateSystem(extent = {{-110, -110}, {150, 150}})),
    Icon(coordinateSystem(extent = {{-110, -110}, {150, 150}})),
    __OpenModelica_commandLineOptions = "");

end Ex10_5;
