model Ex11_1

  Modelica.SIunits.ComplexCurrent Ia0 "zero sequence components of current in line a(A)";
  Modelica.SIunits.ComplexCurrent Ia1 "positive sequence components of current in line a(A)";
  Modelica.SIunits.ComplexCurrent Ia2 "negative sequence components of current in line a(A)";
  Modelica.SIunits.ComplexCurrent Ib0 "zero sequence components of current in line b(A)";
  Modelica.SIunits.ComplexCurrent Ib1 "positive sequence components of current in line b(A)";
  Modelica.SIunits.ComplexCurrent Ib2 "negative sequence components of current in line b(A)";
  Modelica.SIunits.ComplexCurrent Ic0 "zero sequence components of current in line c(A)";
  Modelica.SIunits.ComplexCurrent Ic1 "positive sequence components of current in line c(A)";
  Modelica.SIunits.ComplexCurrent Ic2 "negative sequence components of current in line c(A)";
  Modelica.SIunits.Current Ia1_abs "magnitude of Ia1";
  Modelica.SIunits.Angle Ia1_arg "argument of Ia1";
  Modelica.SIunits.Current Ia2_abs "magnitude of Ia2"; 
  Modelica.SIunits.Angle Ia2_arg "argument of Ia2";
  Modelica.SIunits.Current Ib1_abs "magnitude of Ib1";
  Modelica.SIunits.Angle Ib1_arg "argument of Ib1";
  Modelica.SIunits.Current Ib2_abs "magnitude of Ib2";
  Modelica.SIunits.Angle Ib2_arg "argument of Ib2";
  Modelica.SIunits.Current Ic1_abs "magnitude of Ic1";
  Modelica.SIunits.Angle Ic1_arg "argument of Ic1";
  Modelica.SIunits.Current Ic2_abs "magnitude of Ic2";
  Modelica.SIunits.Angle Ic2_arg "argument of Ic2";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Modelica.SIunits.Current abs_Ia= 10 "magnitude of referrence current in line a" ;
  parameter Modelica.SIunits.Angle arg_Ia= 0 "argument of referrence current in line a";
  parameter Modelica.SIunits.Current abs_Ib= 10 "magnitude of referrence current in line b";
  parameter Modelica.SIunits.Angle arg_Ib= pi "argument of referrence current in line b";
  parameter Modelica.SIunits.Current Ic= 0 "referrence current in line c";
  parameter Modelica.SIunits.ComplexCurrent Ia= Complex(abs_Ia*cos(arg_Ia), abs_Ia*sin(arg_Ia)) "referrence current in line a";
  parameter Modelica.SIunits.ComplexCurrent Ib= Complex(abs_Ib*cos(arg_Ib), abs_Ib*sin(arg_Ib)) "referrence current in line b";
  parameter Complex a= Complex(1*cos(120*D2R), 1*sin(120*D2R)) "operator";
  parameter Complex a2= Complex(1*cos(240*D2R), 1*sin(240*D2R)) "operator";
  
equation
 Ia0= (1/3)*(Ia+Ib+Ic);
 Ia1= ((1/3)*(Ia+Ic))+Complex((1/3)*abs_Ia*cos(arg_Ib+(120*D2R)), (1/3)*abs_Ia*sin((arg_Ib)+(120*D2R)));
 Ia2= ((1/3)*(Ia+Ic))+Complex((1/3)*abs_Ia*cos(arg_Ib+(240*D2R)), (1/3)*abs_Ia*sin((arg_Ib)+(240*D2R)));
 Ia1_abs= sqrt((Ia1.re^2)+(Ia1.im^2));
 Ia1_arg= (atan(Ia1.im/Ia1.re));
 Ia2_abs= sqrt((Ia2.re^2)+(Ia2.im^2));
 Ia2_arg= (atan(Ia2.im/Ia2.re));
 Ib0= Ia0;
 Ib1= a2*Ia1;
 Ib2= a*Ia2;
 Ib1_abs= sqrt((Ib1.re^2)+(Ib1.im^2));
 Ib1_arg= ((atan(Ib1.im/Ib1.re))-pi);
 Ib2_abs= sqrt((Ib2.re^2)+(Ib2.im^2));
 Ib2_arg= (atan(Ib2.im/Ib2.re))+pi;
 Ic0= Ia0;
 Ic1= a*Ia1;
 Ic2= a2*Ia2;
 Ic1_abs= sqrt((Ic1.re^2)+(Ic1.im^2));
 Ic1_arg= (atan(Ic1.im/Ic1.re));
 Ic2_abs= sqrt((Ic2.re^2)+(Ic2.im^2));
 Ic2_arg= (atan(Ic2.im/Ic2.re))-pi;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex11_1;
