model Ex11_2

  Complex Vab1 "symmetrical components of line voltage for positive sequence";
  Complex Vab2 "symmetrical components of line voltage for negative sequence";
  Real Vab1_abs (final unit= "per unit") "magnitude of Vab1";
  Modelica.SIunits.Angle Vab1_arg "argument of Vab1";
  Real Vab2_abs (final unit= "per unit") "magnitude of Vab2";
  Modelica.SIunits.Angle Vab2_arg "argument of Vab2";
  Complex Van1 "line to neutral voltage for positive sequence";
  Complex Van2 "line to neutral voltage for negative sequence";
  Real Van1_abs (final unit= "per unit") "magnitude of Van1";
  Modelica.SIunits.Angle Van1_arg "argument of Van1";
  Real Van2_abs (final unit= "per unit") "magnitude of Van2";
  Modelica.SIunits.Angle Van2_arg "argument of Van2";
  Complex Ia1 "line current for positive sequence";
  Complex Ia2 "line current for negative sequence";
  Real Ia1_abs (final unit= "per unit") "magnitude of Ia1";
  Modelica.SIunits.Angle Ia1_arg "argument of Ia1";
  Real Ia2_abs (final unit= "per unit") "magnitude of Ia2";
  Modelica.SIunits.Angle Ia2_arg "argument of Ia2";
  Complex Va1 "voltage on H-T for positive sequence";
  Complex Va2 "voltage on H-T for negative sequence";
  Complex Va "total voltage";
  Real Va1_abs (final unit= "per unit") "magnitude of Va1";
  Modelica.SIunits.Angle Va1_arg "argumnet of Va1";
  Real Va2_abs (final unit= "per unit") "magnitude of Va2";
  Modelica.SIunits.Angle Va2_arg "argument of Va2";
  Real Va_abs (final unit= "per unit") "magnitude of Va";
  Modelica.SIunits.Angle Va_arg "argument of Va";
  Complex Vb1 "voltage on H-T for positive sequence";
  Complex Vb2 "voltage on H-T for negative sequence";
  Complex Vb "total voltage";
  Real Vb1_abs (final unit= "per unit") "magnitude of Vb1";
  Modelica.SIunits.Angle Vb1_arg "argtument of Vb1";
  Real Vb2_abs (final unit= "per unit") "magnitude of Vb2";
  Modelica.SIunits.Angle Vb2_arg "argument of Vb2";
  Real Vb_abs (final unit= "per unit") "magnitude of Vb";
  Modelica.SIunits.Angle Vb_arg "argument of Vb";
  Complex Vc1 "voltage on H-T for positive sequence";
  Complex Vc2 "voltage on H-T for negative sequence";
  Complex Vc "total voltage";
  Real Vc1_abs (final unit= "per unit") "magnitude of Vc1";
  Modelica.SIunits.Angle Vc1_arg "argument of Vc1";
  Real Vc2_abs (final unit= "per unit") "magnitude of Vc2";
  Modelica.SIunits.Angle Vc2_arg "argument of Vc2";
  Real Vc_abs (final unit= "per unit") "magnitude of Vc";
  Modelica.SIunits.Angle Vc_arg "argument of Vc";
  Complex V_ab "line to neutral voltage base";
  Complex V_bc "line to neutral voltage base";
  Complex V_ca "line to neutral voltage base";
  Real V_ab_abs (final unit= "per unit") "magnitude of V_ab";
  Modelica.SIunits.Angle V_ab_arg "argument of V_ab";
  Real V_bc_abs (final unit= "per unit") "magnitude of V_bc";
  Modelica.SIunits.Angle V_bc_arg "argument of V_bc";
  Real V_ca_abs (final unit= "per unit") "magnitude of V_ca";
  Modelica.SIunits.Angle V_ca_arg "argument of V_ca";
  Complex V_ab_ll "line to line voltage";
  Complex V_bc_ll "line to line voltage";
  Complex V_ca_ll "line to line voltage";
  Real V_ab_ll_abs (final unit= "per unit") "magnitude of V_ab_ll";
  Modelica.SIunits.Angle V_ab_ll_arg "argument of V_ab_ll";
  Real V_bc_ll_abs (final unit= "per unit") "magnitude of V_bc_ll";
  Modelica.SIunits.Angle V_bc_ll_arg "argument of V_bc_ll";
  Real V_ca_ll_abs (final unit= "per unit") "magnitude of V_ca_ll";
  Modelica.SIunits.Angle V_ca_ll_arg "argument of V_ca_ll";
  Complex Ia "line current";
  Complex Ib "line current";
  Complex Ic "line current";
  Real Ia_abs (final unit= "per unit") "magnitude of Ia";
  Modelica.SIunits.Angle Ia_arg "argument of Ia";
  Real Ib_abs (final unit= "per unit") "magnitude of Ib";
  Modelica.SIunits.Angle Ib_arg "argument of Ib";
  Real Ic_abs (final unit= "per unit") "magnitude of Ic";
  Modelica.SIunits.Angle Ic_arg "argument of Ic";

  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Real Vab_abs (final unit= "per unit")= 0.8 "voltage madnitude of resistor load at delta side of tranformer";
  parameter Real Vbc_abs (final unit= "per unit")= 1.2 "voltage madnitude of resistor load at delta side of tranformer";
  parameter Real Vca_abs (final unit= "per unit")= 1.0 "voltage madnitude of resistor load at delta side of tranformer";
  parameter Real Vab_arg (final unit= "deg")= 82.8 "in degrees";
  parameter Real Vbc_arg (final unit= "deg")= -41.4 "in degrees";
  parameter Real Vca_arg (final unit= "deg")= 180 "in degrees";
  parameter Complex Vab= Complex(Vab_abs*cos(Vab_arg*D2R), Vab_abs*sin(Vab_arg*D2R));
  parameter Complex Vbc= Complex(Vbc_abs*cos(Vbc_arg*D2R), Vbc_abs*sin(Vbc_arg*D2R));
  parameter Complex Vca= Complex(Vca_abs*cos(Vca_arg*D2R), Vca_abs*sin(Vca_arg*D2R));
  parameter Real Z (final unit= "per unit")= 1.0 "resistor of each load impedance";
  parameter Complex a= Complex(1*cos(120*D2R), 1*sin(120*D2R)) "operator";
  parameter Complex a2= Complex(1*cos(240*D2R), 1*sin(240*D2R)) "operator";
 // parameter Complex j= Complex(0, 1) "j is considered as a complex number with magnitude 1";

equation
  Vab1= (1/3)*(Vab)+Complex((1/3)*Vbc_abs*cos((Vbc_arg+120)*D2R), (1/3)*Vbc_abs*sin((Vbc_arg+120)*D2R))+Complex((1/3)*Vca_abs*cos((Vca_arg+240)*D2R), (1/3)*Vca_abs*sin((Vca_arg+240)*D2R));
  Vab2= (1/3)*(Vab)+Complex((1/3)*Vbc_abs*cos((Vbc_arg+240)*D2R), (1/3)*Vbc_abs*sin((Vbc_arg+240)*D2R))+Complex((1/3)*Vca_abs*cos((Vca_arg+120)*D2R), (1/3)*Vca_abs*sin((Vca_arg+120)*D2R));
  Vab1_abs= sqrt((Vab1.re^2)+(Vab1.im^2)); 
  Vab2_abs= sqrt((Vab2.re^2)+(Vab2.im^2));
  Vab1_arg= (atan(Vab1.im/Vab1.re));
  Vab2_arg= (atan(Vab2.im/Vab2.re))+pi;
  //Vab2_arg1= Vab2_arg+pi;
  Van1= Complex(Vab1_abs*cos((Vab1_arg-(pi/6))), Vab1_abs*sin((Vab1_arg-(pi/6))));
  Van2= Complex(Vab2_abs*cos((Vab2_arg+(pi/6))), Vab2_abs*sin((Vab2_arg+(pi/6))));
  Van1_abs= sqrt((Van1.re^2)+(Van1.im^2));
  Van1_arg= (atan(Van1.im/Van1.re));
  Van2_abs= sqrt((Van2.re^2)+(Van2.im^2));
  Van2_arg= ((atan(Van2.im/Van2.re)))+pi;
  //Van2_arg1= Van2_arg+180;
  Ia1= Van1/Z;
  Ia2= Van2/Z;
  Ia1_abs= sqrt((Ia1.re^2)+(Ia1.im^2));
  Ia1_arg= (atan(Ia1.im/Ia1.re));
  Ia2_abs= sqrt((Ia2.re^2)+(Ia2.im^2));
  Ia2_arg= ((atan(Ia2.im/Ia2.re)))+pi;//+180;
  //for H-T side of transformer
  Va1= Complex(Vab1_abs*cos((Vab1_arg-(pi/6)-(pi/2))), Vab1_abs*sin((Vab1_arg-(pi/6)-(pi/2))));//-j*Van1;
  Va2= Complex(Vab2_abs*cos(Vab2_arg+(pi/6)+(pi/2)), Vab2_abs*sin((Vab2_arg+(pi/6)+(pi/2))));//j*Van2;
  Va= Va1+Va2;
  Va1_abs= sqrt((Va1.re^2)+(Va1.im^2));
  Va1_arg= (atan(Va1.im/Va1.re));
  Va2_abs= sqrt((Va2.re^2)+(Va2.im^2));
  Va2_arg= (atan(Va2.im/Va2.re));
  Va_abs= sqrt((Va.re^2)+(Va.im^2));
  Va_arg= (atan(Va.im/Va.re));
  Vb1= a2*Va1;
  Vb1_abs= sqrt((Vb1.re^2)+(Vb1.im^2));
  Vb1_arg= ((atan(Vb1.im/Vb1.re)))+pi;//+180;
  Vb2= a*Va2;
  Vb2_abs= sqrt((Vb2.re^2)+(Vb2.im^2));
  Vb2_arg= ((atan(Vb2.im/Vb2.re)))+pi;//+180;
  Vb= Vb1+Vb2;
  Vb_abs= sqrt((Vb.re^2)+(Vb.im^2));
  Vb_arg= ((atan(Vb.im/Vb.re)))+pi;
  Vc1= a*Va1;
  Vc1_abs= sqrt((Vc1.re^2)+(Vc1.im^2));
  Vc1_arg= (atan(Vc1.im/Vc1.re));
  Vc2= a2*Va2;
  Vc2_abs= sqrt((Vc2.re^2)+(Vc2.im^2));
  Vc2_arg= ((atan(Vc2.im/Vc2.re)))+pi;//+180;
  Vc= Vc1+Vc2;
  Vc_abs= sqrt((Vc.re^2)+(Vc.im^2));
  Vc_arg= ((atan(Vc.im/Vc.re)));
  V_ab= Va-Vb;
  V_ab_abs= sqrt((V_ab.re^2)+(V_ab.im^2));
  V_ab_arg= ((atan(V_ab.im/V_ab.re)));
  V_ab_ll= V_ab/sqrt(3);
  V_ab_ll_abs= sqrt((V_ab_ll.re^2)+(V_ab_ll.im^2));
  V_ab_ll_arg= ((atan(V_ab_ll.im/V_ab_ll.re)));
  V_bc= Vb-Vc;
  V_bc_abs= sqrt((V_bc.re^2)+(V_bc.im^2));
  V_bc_arg= ((atan(V_bc.im/V_bc.re)))+pi;//+180;
  V_bc_ll= V_bc/sqrt(3);
  V_bc_ll_abs= sqrt((V_bc_ll.re^2)+(V_bc_ll.im^2));
  V_bc_ll_arg= ((atan(V_bc_ll.im/V_bc_ll.re)))+pi;//+180;
  V_ca= Vc-Va;
  V_ca_abs= sqrt((V_ca.re^2)+(V_ca.im^2));
  V_ca_arg= ((atan(V_ca.im/V_ca.re)))+pi;//+180;
  V_ca_ll= V_ca/sqrt(3);
  V_ca_ll_abs= sqrt((V_ca_ll.re^2)+(V_ca_ll.im^2));
  V_ca_ll_arg= ((atan(V_ca_ll.im/V_ca_ll.re)))+pi;//+180;
  Ia= Va/Z;
  Ib= Vb/Z;
  Ic= Vc/Z;
  Ia_abs= sqrt((Ia.re^2)+(Ia.im^2));
  Ia_arg= (atan(Ia.im/Ia.re));
  Ib_abs= sqrt((Ib.re^2)+(Ib.im^2));
  Ib_arg= ((atan(Ib.im/Ib.re)))+pi;//+180;
  Ic_abs= sqrt((Ic.re^2)+(Ic.im^2));
  Ic_arg= ((atan(Ic.im/Ic.re)));
  
//"The  answer may slightly vary due to  rounding off values" 

end Ex11_2;
