model Ex12_3

  Complex Ia1 "line current in line a for positive sequence";
  Complex Ia2 "line current in line a for negative sequence";
  Complex Ia0 "line current in line a for zero sequence";
  Complex In_pu "line to neutral current(pu)";
  Modelica.SIunits.ComplexCurrent In "line to neutral current";
  Complex Ia_pu "subtransient current in line a (pu)";
  Modelica.SIunits.ComplexCurrent Ia "subtransient current in line a in A";
  Complex Ib_pu "subtransient current in line b (pu)";
  Real Ib_pu_abs (final unit= "per unit") "magnitude of Ib_pu";
  Modelica.SIunits.Angle Ib_pu_arg "argument of Ib_pu";
  Modelica.SIunits.ComplexCurrent Ib "subtransient current in line b in A";
  Modelica.SIunits.Current Ib_abs "magnitude of Ib";
  Modelica.SIunits.Angle Ib_arg "argument of Ib";
  Complex Ic_pu "subtransient current in line c (pu)";
  Real Ic_pu_abs (final unit= "per unit") "magnitude of Ic_pu";
  Modelica.SIunits.Angle Ic_pu_arg "argument of Ic_pu";
  Modelica.SIunits.ComplexCurrent Ic "subtransient current in line c in A";
  Modelica.SIunits.Current Ic_abs "magnitude of Ic";
  Modelica.SIunits.Angle Ic_arg "argument of Ic";
  Complex Va1 "symmetrical components of voltage from a to ground in pu";
  Complex Va2 "symmetrical components of voltage from a to ground in pu";
  Complex Va0 "symmetrical components of voltage from a to ground in pu";
  Complex Va "line to ground voltage in pu";
  Complex Vb "line to line voltage in pu";
  Complex Vc "line to line voltage in pu";
  Complex Vab "line to line voltage in pu";
  Real Vab_abs (final unit= "per unit") "magnitude of Vab";
  Modelica.SIunits.Angle Vab_arg "argument of Vab";
  Complex Vbc "line to line voltage in pu";
  Complex Vca "line to line voltage in pu";
  Real Vca_abs (final unit= "per unit") "magnitude of Vca";
  Modelica.SIunits.Angle Vca_arg "argument of Vca";
  Complex Vab_ll "line to line voltage in KV";
  OpenIPSL.Types.VoltageKilo Vab_ll_abs "magnitude of Vab_ll";
  Modelica.SIunits.Angle Vab_ll_arg "argument of Vab_ll";
  Complex Vbc_ll "line to line voltage in KV";
  Complex Vca_ll "line to line voltage in KV";
  OpenIPSL.Types.VoltageKilo Vca_ll_abs "magnitude of Vca_ll";
  Modelica.SIunits.Angle Vca_ll_arg "argument of Vca_ll";

  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= 20 "base power of the generator in MVA";
  parameter OpenIPSL.Types.VoltageKilo Eb= 13.8 "base voltage of generatorin KV";
  parameter Modelica.SIunits.Current I_b= (Sb*1e3)/(Eb*(sqrt(3))) "base current in A";
  parameter Real Ea (final unit= "per unit")= 1.0 "per unit voltage";
  parameter Complex Z0= Complex(0, 0.10) "zero sequence reactance";
  parameter Complex Z1= Complex(0, 0.25) "sub transient reactance";
  parameter Complex Z2= Complex(0, 0.35) "negative sequence reactance";
  parameter Complex a= Complex(1*cos(120*D2R), 1*sin(120*D2R)) "operator";
  parameter Complex a2= Complex(1*cos(240*D2R), 1*sin(240*D2R)) "operator";
  
equation
  Ia1= Ea/(Z1+((Z2*Z0)/(Z0+Z2)));
  Va1= Ea-(Ia1*Z1);
  Va2= Va1;
  Va0= Va1;
  Ia2= -Va2/Z2;
  Ia0= -Va0/Z0;
  Ia_pu= Ia1+Ia2+Ia0;
  Ia= Ia_pu*I_b;
  Ib_pu= (a2*Ia1)+(a*Ia2)+Ia0;
  Ib_pu_abs= sqrt((Ib_pu.re^2)+(Ib_pu.im^2));
  Ib_pu_arg= ((atan(Ib_pu.im/Ib_pu.re)))+pi;//+180;
  Ib= Ib_pu*I_b;
  Ib_abs= sqrt((Ib.re^2)+(Ib.im^2));
  Ib_arg= ((atan(Ib.im/Ib.re)))+pi;//+180;
  Ic_pu= (a*Ia1)+(a2*Ia2)+Ia0;
  Ic_pu_abs= sqrt((Ic_pu.re^2)+(Ic_pu.im^2));
  Ic_pu_arg= ((atan(Ic_pu.im/Ic_pu.re)));//+180;
  Ic= Ic_pu*I_b;
  Ic_abs= sqrt((Ic.re^2)+(Ic.im^2));
  Ic_arg= ((atan(Ic.im/Ic.re)));
  In_pu= 3*Ia0;
  In= In_pu*I_b;
  Va= Va1+Va2+Va0;
  Vb= Complex(0,0);
  Vc= Complex(0,0);
  Vab= Va-Vb;
  Vab_abs= sqrt((Vab.re^2)+(Vab.im^2));
  Vab_arg= ((atan(Vab.im/Vab.re)));
  Vbc= Vb-Vc;
  Vca= Vc-Va;
  Vca_abs= sqrt((Vca.re^2)+(Vca.im^2));
  Vca_arg= ((atan(Vca.im/Vca.re)))+pi;//+180;
  Vab_ll= (Vab*Eb)/sqrt(3);
  Vab_ll_abs= sqrt((Vab_ll.re^2)+(Vab_ll.im^2));
  Vab_ll_arg= ((atan(Vab_ll.im/Vab_ll.re)));
  Vbc_ll= (Vbc*Eb)/sqrt(3);
  Vca_ll= (Vca*Eb)/sqrt(3);
  Vca_ll_abs= sqrt((Vca_ll.re^2)+(Vca_ll.im^2));
  Vca_ll_arg= ((atan(Vca_ll.im/Vca_ll.re)))+pi;//+180;;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex12_3;
