model Ex13_3

  Modelica.SIunits.ComplexCurrent If_max5 "max fault current at bus 5";
  Modelica.SIunits.ComplexCurrent If_min5 "min fault current at bus 5";
  Modelica.SIunits.ComplexCurrent If_max4 "max fault current at bus 4";
  Modelica.SIunits.ComplexCurrent If_min4 "min fault current at bus 4";
  Modelica.SIunits.ComplexCurrent If_max3 "max fault current at bus 3";
  Modelica.SIunits.ComplexCurrent If_min3 "min fault current at bus 3";
  Modelica.SIunits.ComplexCurrent If_max2 "max fault current at bus 2";
  Modelica.SIunits.ComplexCurrent If_min2 "min fault current at bus 2";
  Modelica.SIunits.ComplexCurrent If_max1 "max fault current at bus 1";
  Modelica.SIunits.ComplexCurrent If_min1 "min fault current at bus 1";
  Modelica.SIunits.Current Ip4 "current for relay 4";
  Modelica.SIunits.Current Ip3 "current for relay 3";
  Modelica.SIunits.Time t3 "operating time of Relay 3";
  Modelica.SIunits.Current Ip2 "current for relay 2";
  Real t2 "Relay pickup setting";
  
  
  parameter Modelica.SIunits.ComplexImpedance X_1 = Complex(0, 9.6) "reactance of line 1";
  parameter Modelica.SIunits.ComplexImpedance X_2 = Complex(0, 6.4) "reactance of line 2";
  parameter Modelica.SIunits.ComplexImpedance X_3 = Complex(0, 8.0) "reactance of line 3";
  parameter Modelica.SIunits.ComplexImpedance X_4 = Complex(0, 12.8) "reactance of line 4";
  parameter Modelica.SIunits.ComplexImpedance X_tr1 = Complex(0, 5) "reactance of transformer";
  parameter Modelica.SIunits.ComplexImpedance X_tr2 = Complex(0, 5) "reactance of transformer";
  parameter Modelica.SIunits.ComplexImpedance X_treq = X_tr1 * X_tr2 / (X_tr1 + X_tr2) "equivalent reactance of transformer";
 inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100) annotation(
    Placement(visible = true, transformation(origin = {-86, 88}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1, V_b = 220) annotation(
    Placement(visible = true, transformation(origin = {-93, 4.44089e-16}, extent = {{-7, -8}, {7, 8}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 0.577, V_b = 13.8, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-57, -1}, extent = {{-11, -11}, {11, 11}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_0 = 0.577, V_b = 13.8, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-18, -2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_0 = 0.577, V_b = 13.8, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {16, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus4(V_0 = 0.577, V_b = 13.8, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {52, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus5(V_0 = 0.577, V_b = 13.8, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {84, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 100, V_b = 13.8, Vn = 13.8, kT = 15.94, r = 0, x = 2.626) annotation(
    Placement(visible = true, transformation(origin = {-73, 9}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(Sn = 100, V_b = 13.8, Vn = 13.8, kT = 15.94, r = 0, x = 2.626) annotation(
    Placement(visible = true, transformation(origin = {-73, -9}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 5.042) annotation(
    Placement(visible = true, transformation(origin = {-31, -1}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 3.361) annotation(
    Placement(visible = true, transformation(origin = {5, -1}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 4.202) annotation(
    Placement(visible = true, transformation(origin = {41, 1}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0, G = 0, R = 0, X = 6.723) annotation(
    Placement(visible = true, transformation(origin = {74, -6.66134e-16}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1(V_0 = 1, V_b = 13.8) annotation(
    Placement(visible = true, transformation(origin = {-51, -49}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2(V_0 = 1, V_b = 13.8) annotation(
    Placement(visible = true, transformation(origin = {-15, -49}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant3(V_0 = 1, V_b = 13.8) annotation(
    Placement(visible = true, transformation(origin = {20, -50}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant4(V_0 = 1, V_b = 13.8) annotation(
    Placement(visible = true, transformation(origin = {61, -51}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant5(V_0 = 1, V_b = 13.8) annotation(
    Placement(visible = true, transformation(origin = {87, -49}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-45, -1}, extent = {{-3, -3}, {3, 3}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-9, -1}, extent = {{-3, -3}, {3, 3}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker3(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {27, 1}, extent = {{-3, -3}, {3, 3}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker4(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {61, -2.22045e-16}, extent = {{-3, -4}, {3, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 0.66, t1 = 15, t2 = 45) annotation(
    Placement(visible = true, transformation(origin = {93, -21}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
equation
  connect(twoWindingTransformer2.n, bus1.p) annotation(
    Line(points = {{-65, -9}, {-62, -9}, {-62, 0}, {-56, 0}}, color = {0, 0, 255}));
  connect(infiniteBus1.p, twoWindingTransformer2.p) annotation(
    Line(points = {{-86, 0}, {-82, 0}, {-82, -9}, {-81, -9}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-66, 10}, {-62, 10}, {-62, 0}, {-56, 0}, {-56, 0}}, color = {0, 0, 255}));
  connect(infiniteBus1.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-86, 0}, {-82, 0}, {-82, 8}, {-80, 8}, {-80, 10}}, color = {0, 0, 255}));
  connect(bus1.p, voltDependant1.p) annotation(
    Line(points = {{-56, 0}, {-52, 0}, {-52, -42}, {-51, -42}}, color = {0, 0, 255}));
  connect(bus4.p, voltDependant4.p) annotation(
    Line(points = {{52, 0}, {60, 0}, {60, -44}, {61, -44}}, color = {0, 0, 255}));
  connect(bus3.p, voltDependant3.p) annotation(
    Line(points = {{16, 0}, {20, 0}, {20, -44}}, color = {0, 0, 255}));
  connect(bus2.p, voltDependant2.p) annotation(
    Line(points = {{-18, -2}, {-14, -2}, {-14, -42}, {-15, -42}}, color = {0, 0, 255}));
  connect(bus3.p, breaker3.s) annotation(
    Line(points = {{16, 0}, {23, 0}, {23, 1}}, color = {0, 0, 255}));
  connect(breaker3.r, pwLine3.p) annotation(
    Line(points = {{31, 1}, {35, 1}}, color = {0, 0, 255}));
  connect(bus5.p, voltDependant5.p) annotation(
    Line(points = {{84, 0}, {86, 0}, {86, -42}, {87, -42}}, color = {0, 0, 255}));
  connect(pwFault1.p, bus5.p) annotation(
    Line(points = {{94, -16}, {96, -16}, {96, 0}, {84, 0}}, color = {0, 0, 255}));
  connect(pwLine4.n, bus5.p) annotation(
    Line(points = {{79, 0}, {84, 0}}, color = {0, 0, 255}));
  connect(breaker4.r, pwLine4.p) annotation(
    Line(points = {{65, 0}, {69, 0}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus4.p) annotation(
    Line(points = {{47, 1}, {48.5, 1}, {48.5, 0}, {52, 0}}, color = {0, 0, 255}));
  connect(breaker4.s, bus4.p) annotation(
    Line(points = {{57, 0}, {52, 0}}, color = {0, 0, 255}));
  connect(breaker2.r, pwLine2.p) annotation(
    Line(points = {{-5, -1}, {-1, -1}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus3.p) annotation(
    Line(points = {{11, -1}, {13.5, -1}, {13.5, 0}, {16, 0}}, color = {0, 0, 255}));
  connect(bus2.p, breaker2.s) annotation(
    Line(points = {{-18, -2}, {-14, -2}, {-14, -1}, {-13, -1}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{-25, -1}, {-20.5, -1}, {-20.5, -2}, {-18, -2}}, color = {0, 0, 255}));
  connect(breaker1.r, pwLine1.p) annotation(
    Line(points = {{-41, -1}, {-37, -1}}, color = {0, 0, 255}));
  connect(bus1.p, breaker1.s) annotation(
    Line(points = {{-57, -1}, {-49, -1}}, color = {0, 0, 255}));
  If_max5 = (bus5.V_b*1e3) / sqrt(3) / (X_treq + X_1 + X_2 + X_3 + X_4);
  If_min5 = (sqrt(3) / 2)*((bus5.V_b*1e3) / sqrt(3) / (X_tr1 + X_1 + X_2 + X_3 + X_4));
  If_max4 = (bus4.V_b*1e3) / sqrt(3) / (X_treq + X_1 + X_2 + X_3);
  If_min4 = (sqrt(3) / 2)*((bus4.V_b*1e3) / sqrt(3) / (X_tr1 + X_1 + X_2 + X_3));
  If_max3 = (bus3.V_b*1e3) / sqrt(3) / (X_treq + X_1 + X_2);
  If_min3 = (sqrt(3) / 2)*((bus3.V_b*1e3) / sqrt(3) / (X_tr1 + X_1 + X_2));
  If_max2 = (bus2.V_b*1e3) / sqrt(3) / (X_treq + X_1);
  If_min2 = (sqrt(3) / 2)*((bus2.V_b*1e3) / sqrt(3) / (X_tr1 + X_1));
  If_max1 = (bus1.V_b*1e3) / sqrt(3) / X_treq;
  If_min1 = (sqrt(3) / 2) *((bus1.V_b*1e3) / sqrt(3) / X_tr1);
// setting for Relay 4
  Ip4 = (sqrt(If_min5.re ^ 2 + If_min5.im ^ 2) / 3)*(5/50);
// setting for Relay 3
  Ip3 = sqrt(If_max4.re ^ 2 + If_max4.im ^ 2) * (5 / 50);
  t3= 0.135+(0.3);
// setting for Relay 2
  Ip2 = sqrt(If_min4.re ^ 2 + If_min4.im ^ 2) / 3 * (5 / 100);
  t2 = sqrt(If_max3.re ^ 2 + If_max3.im ^ 2) * (5 / 100) * (1 / 4);
  
  annotation(
    Diagram,
    Icon,
    __OpenModelica_commandLineOptions = "");
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex13_3;
