model Ex13_4

  Modelica.SIunits.Current Il_max "maximum load current in A";
  Modelica.SIunits.Voltage Vn "system voltage to neutral in V";
  Real CVT "CVT ratio";
  Modelica.SIunits.ComplexImpedance  Z12r "impedance of line 1-2 for relay12";
  Modelica.SIunits.ComplexImpedance  Z23r "impedance of line 2-3 for relay12";
  Modelica.SIunits.ComplexImpedance  Z24r "impedance of line 2-4 for relay12";
  Modelica.SIunits.ComplexImpedance  Zload "load impedance due to max load current";
  Modelica.SIunits.ComplexImpedance  Z12r_1 "zone 1 setting of the relay12 impedance";
  Modelica.SIunits.ComplexImpedance  Z23r_1 "zone 2 setting of the relay12 impedance";
  Modelica.SIunits.ComplexImpedance  Z24r_1 "zone 3 setting of the relay12 impedance";

  parameter OpenIPSL.Types.VoltageKilo  Vb= 138 "base voltage of the transmission system";
  parameter Real l1 (final unit="Km")= 64 "length of transmision line 1 in Km";
  parameter Real l2 (final unit="Km")= 64 "length of transmision line 2 in Km";
  parameter Real l3 (final unit="Km")= 96 "length of transmision line 3 in Km";
  parameter Modelica.SIunits.ComplexImpedance Z= Complex(0.05, 0.5) "positive sequence impedance of transmision line per Km";
  parameter Modelica.SIunits.ComplexImpedance  Z1= l1*Z "positive sequence impedance of transmision  line 1 in ohms";
  parameter Modelica.SIunits.ComplexImpedance  Z2= l2*Z "positive sequence impedance of transmision  line 2 in ohms";
  parameter Modelica.SIunits.ComplexImpedance  Z3= l3*Z "positive sequence impedance of transmision  line 3 in ohms";
  parameter OpenIPSL.Types.ActivePowerMega Sl_max= 50 "max load power";
  parameter Real pf1= 0.8 "power factor";
  
  
  
equation
  Il_max= (Sl_max*1e6)/(Vb*1e3*sqrt(3));
  Vn= (Vb*1e3)/(sqrt(3));
  CVT= Vn/67;
  Z12r= Z1*(40/CVT);
  Z23r= Z2*(40/CVT);
  Z24r= Z3*(40/CVT);
  Zload= (67*(Complex(0.8, 0.6)))/(Il_max*(5/200));
  Z12r_1= 0.8*Z12r;
  Z23r_1= (1.2)*Z23r;
  Z24r_1= (1.2*Z24r)+Z23r;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex13_4;
