model Ex14_2

  Real Ek (final unit="MJ") "kinetic energy of rotation olf two machines in MJ";
  Real Heq (final unit="MJ/MVA") "H for 100 MVA system"; 
  
  parameter OpenIPSL.Types.ApparentPowerMega Sm1= 500 "power rating of the generator1";
  parameter OpenIPSL.Types.ApparentPowerMega Sm2= 1333 "power rating of the generator 2";
  parameter OpenIPSL.Types.VoltageKilo Vn1= 20 "voltage rating of generator1";
  parameter OpenIPSL.Types.VoltageKilo Vn2= 22 "voltage rating of generator2";
  parameter Real H1 (final unit="MJ/MVA")= 4.8 "inertia constant of the generator1 in MJ/MVA";
  parameter Real H2 (final unit="MJ/MVA")= 3.27 "inertia constant of the generator2 in MJ/MVA";
  parameter Real N1 (final unit="RPM")= 3600 "speed of generator1 in rpm";
  parameter Real N2 (final unit="RPM")= 1800 "speed of generator2 in rpm";
  parameter Real pf1= 0.85 "power factor of generator1";
  parameter Real pf2= 0.9 "power factor of generator2";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= 100 "base power";
  
equation
  Ek= (H1*Sm1)+(H2*Sm2);
  Heq= Ek/Sb;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex14_2;
