model Ex14_7
 Real d_crit(final unit = "rad") "critical angle in radian";
  Modelica.SIunits.Time t_crit "critical time";
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 500, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-88, 90}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 10, Sn = 500, V_0 = 1.0, V_b = 400, Vn = 400, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {-84, 0}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-42, -2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {46, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 500, V_b = 400, Vn = 400, r = 0.0, x = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-57, -1}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-24, 6}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {32, 6}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker3(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-24, -6}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker4(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {32, -6}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {6, 6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {6, -6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  constant Real pi = 2 * Modelica.Math.asin(1.0);
  constant Real D2R = pi / 180 "Degree to Radian";
  constant Real R2D = 180 / pi "Radian to Degree";
  parameter Real delta(final unit = "deg") = 28.44 "rotor angle";
  parameter Real delta_rad(final unit = "rad") = delta * D2R "initial rotor angle in radian";
  parameter Real Ws(final unit = "rad/s") = 377 "synchronous speed";
  parameter Real Pm(final unit = "per unit") = 1.0 "mechanical input power";
  parameter Real Pe(final unit = "per unit") = 2.10 * sin(delta_rad) "electrical power";
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0.1, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {22, -34}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Events.Breaker breaker5(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-20, -18}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker6(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {22, -56}, extent = {{-4, -4}, {4, 4}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus3 annotation(
    Placement(visible = true, transformation(origin = {22, -72}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator2(D = 0, M = 10, Sn = 500, V_0 = 1, V_b = 400, Vn = 400, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {23, -87}, extent = {{-7, -7}, {7, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 0.1, t1 = 15, t2 = 45) annotation(
    Placement(visible = true, transformation(origin = {-8, -58}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus4 annotation(
    Placement(visible = true, transformation(origin = {-70, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1 annotation(
    Placement(visible = true, transformation(origin = {88, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(infiniteBus1.p, bus2.p) annotation(
    Line(points = {{98, 0}, {46, 0}, {46, 0}, {46, 0}}, color = {0, 0, 255}));
  connect(generator1.p, bus4.p) annotation(
    Line(points = {{-76, 0}, {-70, 0}, {-70, 0}, {-70, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.p, bus4.p) annotation(
    Line(points = {{-64, 0}, {-72, 0}, {-72, 0}, {-70, 0}, {-70, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-50, 0}, {-42, 0}, {-42, -2}, {-42, -2}, {-42, -2}}, color = {0, 0, 255}));
  connect(breaker5.r, pwFault1.p) annotation(
    Line(points = {{-15, -18}, {-8, -18}, {-8, -50}}, color = {0, 0, 255}));
  connect(breaker5.r, pwLine1.n) annotation(
    Line(points = {{-15, -18}, {22, -18}, {22, -25}}, color = {0, 0, 255}));
  connect(breaker5.s, bus1.p) annotation(
    Line(points = {{-25, -18}, {-32, -18}, {-32, -8}, {-42, -8}, {-42, -2}}, color = {0, 0, 255}));
  connect(pwLine3.n, breaker4.s) annotation(
    Line(points = {{15, -6}, {27, -6}}, color = {0, 0, 255}));
  connect(breaker4.r, bus2.p) annotation(
    Line(points = {{37, -6}, {46, -6}, {46, 0}}, color = {0, 0, 255}));
  connect(breaker3.r, pwLine3.p) annotation(
    Line(points = {{-19, -6}, {-3, -6}}, color = {0, 0, 255}));
  connect(breaker3.s, bus1.p) annotation(
    Line(points = {{-29, -6}, {-42, -6}, {-42, -2}}, color = {0, 0, 255}));
  connect(breaker2.r, bus2.p) annotation(
    Line(points = {{37, 6}, {46, 6}, {46, 0}}, color = {0, 0, 255}));
  connect(pwLine2.n, breaker2.s) annotation(
    Line(points = {{15, 6}, {27, 6}}, color = {0, 0, 255}));
  connect(breaker1.r, pwLine2.p) annotation(
    Line(points = {{-19, 6}, {-3, 6}}, color = {0, 0, 255}));
  connect(breaker1.s, bus1.p) annotation(
    Line(points = {{-29, 6}, {-42, 6}, {-42, -2}}, color = {0, 0, 255}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-90.4, 8.8}, {-90.4, 21.8}, {-98.4, 21.8}, {-98.4, 3.8}, {-94.4, 3.8}}, color = {0, 0, 127}));
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-90.4, -8.8}, {-90.4, -19.8}, {-98.4, -19.8}, {-98.4, -1.8}, {-94.4, -1.8}, {-94.4, -3.8}}, color = {0, 0, 127}));
  connect(generator2.vf0, generator2.vf) annotation(
    Line(points = {{16, -92}, {8, -92}, {8, -98}, {20, -98}, {20, -96}, {20, -96}, {20, -96}}, color = {0, 0, 127}));
  connect(generator2.pm0, generator2.pm) annotation(
    Line(points = {{30, -92}, {40, -92}, {40, -98}, {26, -98}, {26, -96}, {26, -96}, {26, -96}}, color = {0, 0, 127}));
  connect(bus3.p, generator2.p) annotation(
    Line(points = {{22, -72}, {22, -72}, {22, -80}, {24, -80}}, color = {0, 0, 255}));
  connect(breaker6.s, bus3.p) annotation(
    Line(points = {{22, -61}, {22, -72}}, color = {0, 0, 255}));
  connect(pwLine1.p, breaker6.r) annotation(
    Line(points = {{22, -43}, {22, -51}}, color = {0, 0, 255}));
  d_crit = acos((pi - 2 * delta_rad) * sin(delta_rad) - cos(delta_rad));
  t_crit = sqrt(2 * generator1.M * (d_crit - delta_rad) / (Ws * Pm));
//"The  answer may slightly vary due to  rounding off values"
  annotation(
    Diagram,
    Icon,
    __OpenModelica_commandLineOptions = "");

end Ex14_7;
