model Ex3_1
Real R0 (final unit="ohm per 1000 ft") "Dc resistance at 20C";
  Real R1 (final unit="ohm per 1000 ft") "Dc resistance at 50C";
  Real R2 "ratio";
  
  parameter Real Rdc (final unit="ohm per 1000 ft") = 0.01558 "Dc resistance at 20C";
  parameter Real R (final unit="ohm per 1000 ft") = 0.0956 "Ac resistance at 50C";
  parameter Real A (final unit="cmil") = 1113000 "size of the conductor with 61 strands";
  parameter Real l (final unit="ft") = 17 "length of conductor";
  parameter Real p = 1.02 "2% increase in spiralling";
  parameter Modelica.SIunits.Temp_C T = 228 "Tempearture for hard-drawn aluminum for 61% conductivity";
  parameter Modelica.SIunits.Temp_C t1 = 20 "temperature of dc resistance";
  parameter Modelica.SIunits.Temp_C t2= 50 "temperature of ac resistance";
  parameter Real q = 5.280 "obtained from chart";
equation
  R0 = (l*1000*p)/A;
  R1 = R0*((T+t2)/(T+t1));
  R2 = R/(R1*q);
 
//"The  answer may slightly vary due to  rounding off values" 
end Ex3_1;
