model Ex3_4
Real Deq (final unit="ft") "Geometric mean of the 3 distances between 3 conductors" ;
  Real L (final unit="H/m") "inductance in H/m";
  Real Xl (final unit="ohm/mi per phase") "Inductive reactance";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  parameter Real Ds (final unit="ft")= 0.0373 "GMR of the conductor";
  parameter Real Dab (final unit="ft")= 20 "Diameter of the conductor a and b";
  parameter Real Dac (final unit="ft")= 20 "Diameter of the conductor a and c";
  parameter Real Dbc (final unit="ft")= 38 "Diameter of the conductor b and c";
  parameter Real Xd (final unit="ohm/mi per phase")= 0.389 "Inductive reactance obtained from chart";

equation
  Deq= (Dab*Dac*Dbc)^(1/3);
  L= 2e-7*(log(Deq/Ds));
  Xl= 2*60*pi*1609*L;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex3_4;
