model Ex3_5
Modelica.SIunits.Length Dsb "GMR of bundled conductor";
  Modelica.SIunits.Length Deq "Geometric mean of three conductors";
  Real Xl (final unit="ohm/km per phase")"inductive reactance in ohm/km per phase";
  Real Xl1 (final unit="ohm/mi per phase")"inductive reactance in ohm/mi per phase";
  Modelica.SIunits.Impedance Z_b "base impedance";
  Real X (final unit="per unit")"per unit impedance of the line";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  parameter Real Ds (final unit="ft")= 0.0466 "GMR of the individual conductor";
  parameter Modelica.SIunits.Length Dab= 8 "Diameter of the conductor a and b";
  parameter Modelica.SIunits.Length Dac= 16 "Diameter of the conductor a and c";
  parameter Modelica.SIunits.Length Dbc= 8 "Diameter of the conductor b and c";
  parameter OpenIPSL.Types.VoltageKilo V_b= 345 "base voltage";
  parameter OpenIPSL.Types.ApparentPowerMega S_b= 100 "base power";
  parameter Modelica.SIunits.Length l= 160e3 "length of the line";
  parameter Modelica.SIunits.Length d= 0.45 "spacing between bundled conductors";
  
equation
  Dsb= (sqrt(Ds*0.3048*d));
  Deq= (Dab*Dac*Dbc)^(1/3);
  Xl= 2*60*pi*0.0002*(log(Deq/Dsb));
  Xl1= Xl*1.609;
  Z_b= ((V_b)^2)/S_b;
  X= (Xl*l*1e-3)/(Z_b);
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex3_5;
