model Ex5_2

  Real Deq (final unit= "ft") "Geometric mean of the conductor";
  Complex Z "series impedance per unit length per phase";
  Complex Y "shunt admittance per unit length per phase";
  Complex gama_l "total propagation constant";
  Complex P "generalized circuit constant";
  Complex Q "generalized circuit constant";
  Modelica.SIunits.ComplexImpedance Zc  "characteristic impedance of line";
  Modelica.SIunits.ComplexVoltage Vs "sending end voltage";
  Modelica.SIunits.ComplexCurrent Is "sending end current";
  Complex Zc_b "characteristic impedance of line in per unit";
  Real abs_Z (final unit= "ohm/mi") "magnitude of Z";
  Modelica.SIunits.Angle arg_Z "argument of Z";
  Real abs_Y (final unit= "mho/mi") "magnitude of Y";
  Modelica.SIunits.Angle arg_Y "argument of Y";
  Real abs_gama_l "magnitude of gama_l";
  Modelica.SIunits.Angle arg_gama_l "argument of gama_l";
  Modelica.SIunits.Impedance abs_Zc "magnitude of Zc";
  Modelica.SIunits.Angle arg_Zc "argument of Zc";
  Real Vr (final unit="per unit") "receiving end voltage";
  Real Ir (final unit="per unit") "receiving end current";
  Real abs_P "magnitude of P";
  Modelica.SIunits.Angle arg_P "argument of P";
  Real abs_Q "magnitude of Q";
  Modelica.SIunits.Angle arg_Q "argument of Q";
  Real abs_Vs (final unit="per unit") "magnitude of Vs";
  Modelica.SIunits.Angle arg_Vs "argument of Vs";
  Real abs_Is (final unit="per unit") "magnitude of Is";
  Modelica.SIunits.Angle arg_Is "argument of Is";
  OpenIPSL.Types.VoltageKilo Vl "sending end line voltage";
  Modelica.SIunits.Current Il "sending end line current";
  Modelica.SIunits.Impedance Z_b "base impedance";
  Modelica.SIunits.Current I_b "base current";
  Real abs_Zc_b (final unit="per unit") "magnitude of Zc_b";
  Modelica.SIunits.Angle arg_Zc_b "argument of Zc_b";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Real C1 (final unit="ohm/mi")= 0.415 "inductive reactance obtained for rook conductor";
  parameter Real C2 (final unit="ohm/mi")= 0.4127 "inductive reactance spacing obtained for rook conductor";
  parameter Real a1 (final unit= "Mohm.mi")= 0.0950e6 "capacitive reactance obtained for rook conductor";
  parameter Real a2 (final unit= "Mohm.mi")= 0.1009e6 "capacitive reactance spacing obtained for rook conductor";
  parameter Real l (final unit= "mi")= 230 "lenghth of transmission lines";
  parameter Real Dbc (final unit= "ft")= 23.8 "Diameter of the conductor b and c";
  parameter Real Dab (final unit= "ft")= 23.8 "Diameter of the conductor a and b";
  parameter Real Dac (final unit= "ft")= 47.6 "Diameter of the conductor a and c";
  parameter OpenIPSL.Types.VoltageKilo V_b= 215 "voltage of the line";
  parameter OpenIPSL.Types.ActivePowerMega S_b= 125 "power of the line";
  
equation
 
  Deq= (Dab*Dac*Dbc)^(1/3);
  Z= Complex(0.1603, C1+C2);
  abs_Z= sqrt(((0.1603)^(2))+((C1+C2)^(2)));
  arg_Z= (atan(Z.im/Z.re));
  Y= Complex(0, 1/(a1+a2));
  abs_Y= sqrt(Y.re^(2)+Y.im^(2));
  arg_Y= pi/2;
  abs_gama_l= l*((abs_Z*abs_Y)^(0.5));
  arg_gama_l= ((arg_Z+arg_Y)/(2));
  gama_l= Complex(abs_gama_l*cos(arg_gama_l), abs_gama_l*sin(arg_gama_l));
  abs_Zc= sqrt(abs_Z/abs_Y);
  arg_Zc= ((arg_Z-arg_Y)/(2));
  Zc= Complex(abs_Zc*cos(arg_Zc), abs_Zc*sin(arg_Zc));
  Vr= V_b/V_b;
  I_b= (S_b*1e6)/((V_b*1e3)*(3^0.5));
  Ir= I_b/I_b;
  P= Complex(cosh(gama_l.re)*cos(gama_l.im), sinh(gama_l.re)*sin(gama_l.im));
  abs_P= sqrt(((P.re)^(2))+((P.im)^(2)));
  arg_P= (atan(P.im/P.re));
  Q= Complex(sinh(gama_l.re)*cos(gama_l.im), cosh(gama_l.re)*sin(gama_l.im));
  abs_Q= sqrt(((Q.re)^(2))+((Q.im)^(2)));
  arg_Q= (atan(Q.im/Q.re));
  Z_b= (V_b^2)/S_b;
  Zc_b= Zc/Z_b;
  abs_Zc_b= (((Zc_b.re)^(2))+((Zc_b.im)^2))^0.5;
  arg_Zc_b= (atan((Zc_b.im)/(Zc_b.re)));
  Vs= (Vr*P)+(Ir*Zc_b*Q);
  abs_Vs= (((Vs.re)^2)+((Vs.im)^2))^(0.5);
  arg_Vs= (atan((Vs.im)/(Vs.re)));
  Is= (Ir*P)+((Vr/Zc_b)*Q);
  abs_Is= (((Is.re)^2)+((Is.im)^2))^(0.5);
  arg_Is= (atan((Is.im)/(Is.re)));
  Vl= abs_Vs*V_b;
  Il= abs_Is*I_b;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex5_2;
