model Ex5_6

    Real row_r "reflection co-efficient at receiving end";
    Modelica.SIunits.Voltage V1 "end of line voltage due to reflected wave due to row_r";
    Modelica.SIunits.Voltage Vr1 "receiving end voltage due to row_r";
    Real row_s "reflection co-efficient at sending end";
    Modelica.SIunits.Voltage V2 "end of line voltage due to reflected wave due to row_s";
    Modelica.SIunits.Voltage Vr2 "receiving end voltage due to row_s";
    
    parameter Modelica.SIunits.Voltage Vs= 120 "dc source voltage";
    parameter Modelica.SIunits.Impedance Zc= 30 "impedance of transmission line";
    parameter Modelica.SIunits.Impedance Zt= 90 "terminal resistance of transmission line";
    parameter Modelica.SIunits.Impedance Zs= 0 "impedance of source";
  Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage1(V = 120)  annotation(
    Placement(visible = true, transformation(origin = {-56, 0}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {0, -44}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Resistor resistor1(R = 90)  annotation(
    Placement(visible = true, transformation(origin = {0, 56}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Resistor resistor2(R = 30)  annotation(
    Placement(visible = true, transformation(origin = {40, 0}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
equation
  connect(resistor2.n, ground1.p) annotation(
    Line(points = {{40, -10}, {40, -10}, {40, -28}, {0, -28}, {0, -34}, {0, -34}}, color = {0, 0, 255}));
  connect(resistor1.n, resistor2.p) annotation(
    Line(points = {{10, 56}, {40, 56}, {40, 10}, {40, 10}, {40, 10}}, color = {0, 0, 255}));
  connect(constantVoltage1.n, ground1.p) annotation(
    Line(points = {{-56, -10}, {-56, -10}, {-56, -28}, {0, -28}, {0, -34}, {0, -34}}, color = {0, 0, 255}));
  connect(constantVoltage1.p, resistor1.p) annotation(
    Line(points = {{-56, 10}, {-56, 10}, {-56, 56}, {-10, 56}, {-10, 56}}, color = {0, 0, 255}));
  row_r = (Zt - Zc) / (Zt + Zc);
  V1 = row_r * Vs;
  Vr1 = Vs + V1;
  row_s = (Zs - Zc) / (Zs + Zc);
  V2 = row_s * V1 / 2;
  Vr2 = Vr1 - V1 + V2;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex5_6;
