model Ex6_2

  Modelica.SIunits.ComplexCurrent I1 "current at primary side";
  Modelica.SIunits.Current abs_I1 "magnitude of I1";
  Modelica.SIunits.Angle arg_I1 "argument of I1";
  Modelica.SIunits.ComplexVoltage V2 "secondary side voltage";
  Modelica.SIunits.Voltage abs_V2 "magnitude of V2";
  Modelica.SIunits.Angle arg_V2 "argument of V2";
  Real V_regu "voltage regulation";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Real N1= 2000 "no. of turns at primary";
  parameter Real N2= 500 "no. of turns at secondary";
  parameter Real a= N1/N2 "turns ratio";
  parameter Real b= N2/N1 "turns ratio";
  parameter Modelica.SIunits.Resistance r1= 2 "winding resistance on primary side";
  parameter Modelica.SIunits.Resistance r2= 0.125 "winding resistance on secondary side";
  parameter Modelica.SIunits.Reactance x1= 8 "leakage reactance on primary side";
  parameter Modelica.SIunits.Reactance x2= 0.5 "leakage reactance on secondary side";
  parameter Modelica.SIunits.Impedance z1= 12 "load impedance";
  
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance Z2(Z_ref (re= z1 * a ^ 2, im= 0))  annotation(
    Placement(visible = true, transformation(origin = {38, -28}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance Z1(Z_ref (re= r1 + r2 * a ^ 2, im= x1 + x2 * a ^ 2))  annotation(
    Placement(visible = true, transformation(origin = {-10, 6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource1(V = 1200, f = 50, phi = 0)  annotation(
    Placement(visible = true, transformation(origin = {-60, -22}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {-60, -68}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground2 annotation(
    Placement(visible = true, transformation(origin = {38, -72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(ground2.pin, Z2.pin_n) annotation(
    Line(points = {{38, -62}, {38, -38}}, color = {85, 170, 255}));
  connect(Z1.pin_n, Z2.pin_p) annotation(
    Line(points = {{0, 6}, {38, 6}, {38, -18}}, color = {85, 170, 255}));
  
  I1 = voltageSource1.V / (Z1.Z_ref + Z2.Z_ref);
  abs_I1 = sqrt(I1.re ^ 2 + I1.im ^ 2);
  arg_I1 = atan(I1.im / I1.re);
  V2 = I1 * Z2.Z_ref / a;
  abs_V2 = sqrt(V2.re ^ 2 + V2.im ^ 2);
  arg_V2 = atan(V2.im / V2.re);
  V_regu = ((voltageSource1.V / a - abs_V2) / abs_V2)*100;

  connect(ground1.pin, voltageSource1.pin_n) annotation(
    Line(points = {{-60, -58}, {-60, -58}, {-60, -32}, {-60, -32}, {-60, -32}}, color = {85, 170, 255}));
  connect(voltageSource1.pin_p, Z1.pin_p) annotation(
    Line(points = {{-60, -12}, {-60, -12}, {-60, 6}, {-20, 6}, {-20, 6}}, color = {85, 170, 255}));
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex6_2;
