model Ex6_8

  Complex Zp "leakage reactance at primary in per unit";
  Complex Zs "leakage reactance at secondary in per unit";
  Complex Zt "leakage reactance at tertiary in per unit";
  
  parameter OpenIPSL.Types.VoltageKilo Vp= 66 "Primary Voltage";
  parameter OpenIPSL.Types.ApparentPowerMega Sp= 15 "Power rating at primary";
  parameter OpenIPSL.Types.VoltageKilo Vs= 13.2 "Secondary Voltage";
  parameter OpenIPSL.Types.ApparentPowerMega Ss= 10 "Power rating at secondary";
  parameter OpenIPSL.Types.VoltageKilo Vt= 2.3 "Tertiary Voltage";
  parameter OpenIPSL.Types.ApparentPowerMega St= 5 "Power rating at tertiary";
  parameter OpenIPSL.Types.VoltageKilo Vb= Vp "Base voltage";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= Sp "Base power";
  parameter Complex Zps = Complex(0, 0.07) "Leakage reactance in primary with secondary short-circuited and tertiary open w.r.t Sb & Vb";
  parameter Complex Zpt = Complex(0, 0.09) "Leakage reactance in primary with tertiary short-circuited and secondary open w.r.t Sb & Vb";
  parameter Complex Zst1 = Complex(0, 0.08) "Leakage reactance in secondary with tertiary short-circuited and primary open w.r.t Ss & Vs";
  parameter Complex Zst = Zst1*(Sb/Ss) "Leakage reactance in secondary with tertiary short-circuited and primary open w.r.t Sb & Vb";
  
equation
  Zp= 0.5*(Zps+Zpt-Zst);
  Zs= 0.5*(Zps-Zpt+Zst);
  Zt= 0.5*(-Zps+Zpt+Zst);
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex6_8;
