model Ex7_1
  Complex[4, 4] Ybus "admittance matrix of the network in per unit";
  Complex[4, 1] Ibus "current source in per unit";
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Admittance Ya(Y_ref(re = 0, im = -0.8)) annotation(
    Placement(visible = true, transformation(origin = {-60, 46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Admittance Yc(Y_ref(re = 0, im = -0.8)) annotation(
    Placement(visible = true, transformation(origin = {-60, -20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Admittance Yb(Y_ref(re = 0, im = -0.8)) annotation(
    Placement(visible = true, transformation(origin = {-58, -78}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Admittance Yf(Y_ref(re = 0, im = -4)) annotation(
    Placement(visible = true, transformation(origin = {-28, 28}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Admittance Yg(Y_ref(re = 0, im = -2.5)) annotation(
    Placement(visible = true, transformation(origin = {-30, -36}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Admittance Ye(Y_ref(re = 0, im = -8)) annotation(
    Placement(visible = true, transformation(origin = {42, -4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Admittance Yd(Y_ref(re = 0, im = -5)) annotation(
    Placement(visible = true, transformation(origin = {40, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Admittance Yh(Y_ref(re = 0, im = -5)) annotation(
    Placement(visible = true, transformation(origin = {42, -68}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.CurrentSource currentSource1(I = 1.2, f = 50, phi = -1.5708) annotation(
    Placement(visible = true, transformation(origin = {-60, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.CurrentSource currentSource2(I = 1.2, f = 50, phi = -1.5708) annotation(
    Placement(visible = true, transformation(origin = {-60, 8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.CurrentSource currentSource3(I = 1.2, f = 50, phi = -2.2143) annotation(
    Placement(visible = true, transformation(origin = {-60, -52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {86, -104}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  parameter Complex Y11 = Complex(0, Yd.Y_ref.im + Ya.Y_ref.im + Yf.Y_ref.im) "self admittance of bus 1";
  parameter Complex Y22 = Complex(0, Yh.Y_ref.im + Yb.Y_ref.im + Yg.Y_ref.im) "self admittance of bus 2";
  parameter Complex Y33 = Complex(0, Yf.Y_ref.im + Ye.Y_ref.im + Yg.Y_ref.im + Yc.Y_ref.im) "self admittance of bus 3";
  parameter Complex Y44 = Complex(0, Yd.Y_ref.im + Ye.Y_ref.im + Yh.Y_ref.im) "self admittance of bus 4";
  parameter Complex Y12 = Complex(0, 0) "mutual admittance between bus 1 and 2";
  parameter Complex Y21 = Y12 "mutual admittance between bus 2 and 1";
  parameter Complex Y23 = Complex(0, -Yg.Y_ref.im) "mutual admittance between bus 2 and 3";
  parameter Complex Y32 = Y23 "mutual admittance between bus 3 and 2";
  parameter Complex Y13 = Complex(0, -Yf.Y_ref.im) "mutual admittance between bus 1 and 3";
  parameter Complex Y31 = Y13 "mutual admittance between bus 3 and 1";
  parameter Complex Y14 = Complex(0, -Yd.Y_ref.im) "mutual admittance between bus 1 and 4";
  parameter Complex Y41 = Y14 "mutual admittance between bus 4 and 1";
  parameter Complex Y34 = Complex(0, -Ye.Y_ref.im) "mutual admittance between bus 3 and 4";
  parameter Complex Y43 = Y34 "mutual admittance between bus 4 and 3";
  parameter Complex Y24 = Complex(0, -Yh.Y_ref.im) "mutual admittance between bus 2 and 4";
  parameter Complex Y42 = Y24 "mutual admittance between bus 4 and 2";
equation
  connect(currentSource3.pin_p, Yb.pin_p) annotation(
    Line(points = {{-70, -52}, {-78, -52}, {-78, -78}, {-68, -78}}, color = {85, 170, 255}));
  Ybus = {{Y11, Y12, Y13, Y14}, {Y21, Y22, Y23, Y24}, {Y31, Y32, Y33, Y34}, {Y41, Y42, Y43, Y44}};
  Ibus = {{Complex(currentSource1.I * cos(currentSource1.phi), currentSource1.I * sin(currentSource1.phi))}, {Complex(currentSource3.I * cos(currentSource3.phi), currentSource3.I * sin(currentSource3.phi))}, {Complex(currentSource2.I * cos(currentSource2.phi), currentSource2.I * sin(currentSource2.phi))}, {Complex(0, 0)}};
  connect(Yd.pin_n, ground1.pin) annotation(
    Line(points = {{50, 60}, {86, 60}, {86, -94}}, color = {85, 170, 255}));
  connect(Ye.pin_n, ground1.pin) annotation(
    Line(points = {{52, -4}, {86, -4}, {86, -94}}, color = {85, 170, 255}));
  connect(Yh.pin_n, ground1.pin) annotation(
    Line(points = {{52, -68}, {86, -68}, {86, -94}}, color = {85, 170, 255}));
  connect(Yh.pin_p, currentSource3.pin_n) annotation(
    Line(points = {{32, -68}, {-40, -68}, {-40, -52}, {-50, -52}}, color = {85, 170, 255}));
  connect(currentSource3.pin_n, Yb.pin_n) annotation(
    Line(points = {{-50, -52}, {-40, -52}, {-40, -78}, {-48, -78}}, color = {85, 170, 255}));
  connect(Yg.pin_p, currentSource3.pin_n) annotation(
    Line(points = {{-30, -46}, {-30, -52}, {-50, -52}}, color = {85, 170, 255}));
  connect(Yc.pin_p, currentSource3.pin_p) annotation(
    Line(points = {{-70, -20}, {-78, -20}, {-78, -52}, {-70, -52}}, color = {85, 170, 255}));
  connect(Ye.pin_p, currentSource2.pin_n) annotation(
    Line(points = {{32, -4}, {-44, -4}, {-44, 8}, {-50, 8}}, color = {85, 170, 255}));
  connect(currentSource1.pin_n, Yd.pin_p) annotation(
    Line(points = {{-50, 80}, {-44, 80}, {-44, 60}, {30, 60}, {30, 60}}, color = {85, 170, 255}));
  connect(Yg.pin_n, Yc.pin_n) annotation(
    Line(points = {{-30, -26}, {-30, -20}, {-50, -20}}, color = {85, 170, 255}));
  connect(currentSource2.pin_n, Yc.pin_n) annotation(
    Line(points = {{-50, 8}, {-44, 8}, {-44, -20}, {-50, -20}, {-50, -20}, {-50, -20}}, color = {85, 170, 255}));
  connect(Yf.pin_p, currentSource2.pin_n) annotation(
    Line(points = {{-28, 18}, {-28, 18}, {-28, 8}, {-50, 8}, {-50, 8}, {-50, 8}}, color = {85, 170, 255}));
  connect(Ya.pin_n, Yf.pin_n) annotation(
    Line(points = {{-50, 46}, {-28, 46}, {-28, 38}, {-28, 38}}, color = {85, 170, 255}));
  connect(currentSource1.pin_n, Ya.pin_n) annotation(
    Line(points = {{-50, 80}, {-44, 80}, {-44, 46}, {-50, 46}, {-50, 46}}, color = {85, 170, 255}));
  connect(currentSource2.pin_p, Yc.pin_p) annotation(
    Line(points = {{-70, 8}, {-78, 8}, {-78, -20}, {-70, -20}, {-70, -20}}, color = {85, 170, 255}));
  connect(Ya.pin_p, currentSource2.pin_p) annotation(
    Line(points = {{-70, 46}, {-78, 46}, {-78, 8}, {-70, 8}, {-70, 8}}, color = {85, 170, 255}));
  connect(currentSource1.pin_p, Ya.pin_p) annotation(
    Line(points = {{-70, 80}, {-78, 80}, {-78, 46}, {-70, 46}, {-70, 46}}, color = {85, 170, 255}));
//"The  answer may slightly vary due to  rounding off values"
end Ex7_1;
