model Ex7_7

 Complex [5,5]Zbus_new "new bus impedance matrix after inclusion of capacitor as in Ex_7_5";
 Complex Z11 "element after removal of node 5";
 Complex Z12 "element after removal of node 5";
 Complex Z13 "element after removal of node 5";
 Complex Z14 "element after removal of node 5";
 Complex Z21 "element after removal of node 5";
 Complex Z22 "element after removal of node 5";
 Complex Z23 "element after removal of node 5";
 Complex Z24 "element after removal of node 5";
 Complex Z31 "element after removal of node 5";
 Complex Z32 "element after removal of node 5";
 Complex Z33 "element after removal of node 5";
 Complex Z34 "element after removal of node 5";
 Complex Z41 "element after removal of node 5";
 Complex Z42 "element after removal of node 5";
 Complex Z43 "element after removal of node 5";
 Complex Z44 "element after removal of node 5";
 Complex [4,4]Zbus_eliminated "bus impedamnce matrix after elimination of capacitor";
 Complex V4 "voltage at node 4";
 Real V4_abs (final unit= "per unit") "magnitude of V4";
 Modelica.SIunits.Angle V4_arg "argument of V4";
 
 parameter Complex [4,4]Zbus_orig= {{Complex(0,0.4774),Complex(0,0.3706),Complex(0,0.4020),Complex(0,0.4142)},{Complex(0,0.3706),Complex(0,0.4872),Complex(0,0.3922),Complex(0,0.4126)},{Complex(0,0.4020),Complex(0,0.3922),Complex(0,0.4558),Complex(0,0.4232)},{Complex(0,0.4142),Complex(0,0.4126),Complex(0,0.4232),Complex(0,0.4733)}} "original bus impedance matrix ";
  parameter Complex Zb= Complex(0,-5) "impedance of capacitor";
  parameter Complex [4,1]Ibus = {{Complex(0, -1.20)}, {Complex(-0.72, -0.96)}, {Complex(0, -1.20)}, {Complex(0, 0)}} "refer EX_7_2";

equation

  Zbus_new= {{Complex(0,0.4774),Complex(0,0.3706),Complex(0,0.4020),Complex(0,0.4142),Zbus_orig[4,1]},{Complex(0,0.3706),Complex(0,0.4872),Complex(0,0.3922),Complex(0,0.4126),Zbus_orig[4,2]},{Complex(0,0.4020),Complex(0,0.3922),Complex(0,0.4558),Complex(0,0.4232),Zbus_orig[4,3]},{Complex(0,0.4142),Complex(0,0.4126),Complex(0,0.4232),Complex(0,0.4733),Zbus_orig[4,4]},{Zbus_orig[4,1],Zbus_orig[4,2],Zbus_orig[4,3],Zbus_orig[4,4],(Zbus_orig[4,4]+Zb)}};
  //to eliminate node 5
  Z11= Zbus_new[1,1]-((Zbus_new[1,5]*Zbus_new[5,1])/Zbus_new[5,5]);
  Z12= Zbus_new[1,2]-((Zbus_new[1,5]*Zbus_new[5,2])/Zbus_new[5,5]);
  Z13= Zbus_new[1,3]-((Zbus_new[1,5]*Zbus_new[5,3])/Zbus_new[5,5]);
  Z14= Zbus_new[1,4]-((Zbus_new[1,5]*Zbus_new[5,4])/Zbus_new[5,5]);
  
  Z21= Zbus_new[2,1]-((Zbus_new[2,5]*Zbus_new[5,1])/Zbus_new[5,5]);
  Z22= Zbus_new[2,2]-((Zbus_new[2,5]*Zbus_new[5,2])/Zbus_new[5,5]);
  Z23= Zbus_new[2,3]-((Zbus_new[2,5]*Zbus_new[5,3])/Zbus_new[5,5]);
  Z24= Zbus_new[2,4]-((Zbus_new[2,5]*Zbus_new[5,4])/Zbus_new[5,5]);  
  
  Z31= Zbus_new[3,1]-((Zbus_new[3,5]*Zbus_new[5,1])/Zbus_new[5,5]);
  Z32= Zbus_new[3,2]-((Zbus_new[3,5]*Zbus_new[5,2])/Zbus_new[5,5]);
  Z33= Zbus_new[3,3]-((Zbus_new[3,5]*Zbus_new[5,3])/Zbus_new[5,5]);
  Z34= Zbus_new[3,4]-((Zbus_new[3,5]*Zbus_new[5,4])/Zbus_new[5,5]);

  Z41= Zbus_new[4,1]-((Zbus_new[4,5]*Zbus_new[5,1])/Zbus_new[5,5]);
  Z42= Zbus_new[4,2]-((Zbus_new[4,5]*Zbus_new[5,2])/Zbus_new[5,5]);
  Z43= Zbus_new[4,3]-((Zbus_new[4,5]*Zbus_new[5,3])/Zbus_new[5,5]);
  Z44= Zbus_new[4,4]-((Zbus_new[4,5]*Zbus_new[5,4])/Zbus_new[5,5]);
  
  Zbus_eliminated= {{Z11,Z12,Z13,Z14}, {Z21,Z22,Z23,Z24}, {Z31,Z32,Z33,Z34}, {Z41,Z42,Z43,Z44}};
  
  V4= Zbus_eliminated[4,1]*Ibus[1,1]+Zbus_eliminated[4,2]*Ibus[2,1]+Zbus_eliminated[4,3]*Ibus[3,1]+Zbus_eliminated[4,4]*Ibus[4,1];
  V4_abs= sqrt(V4.re^2+V4.im^2);
  V4_arg= atan(V4.im/V4.re);
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex7_7;
