model Ex8_1

  Complex Y21 "mutual admittance between bus 2 and 1";
  Real Y21_abs (final unit= "per unit") "magnitude of Y21";
  Modelica.SIunits.Angle Y21_arg "argument of Y21";
  Complex Y23 "mutual admittance between bus 2 and 3";
  Real Y23_abs (final unit= "per unit") "magnitude of Y23";
  Modelica.SIunits.Angle Y23_arg "argument of Y23";
  //Complex Y22 "self admittance of bus 2";
  // Real Y22_abs;
  // Modelica.SIunits.Angle Y22_arg "in degree";
  // Modelica.SIunits.Angle Y22_arg1 "in degree";
  Real P2_cal (final unit= "per unit") "Real power entering bus 2";
  Real Ps (final unit= "per unit") "scheduled power in the network at bus 2";
  Real P2_del (final unit= "per unit") "change in power";
  Real P2_d3 (final unit= "per unit") "2nd element in 1st row of Jacobian";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50)  annotation(
    Placement(visible = true, transformation(origin = {-6, 88}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = 100, V_0 = 1, V_b = 138, Vn = 138, ra = 0.001, x1d = 0.2)  annotation(
    Placement(visible = true, transformation(origin = {-80, 76}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator2(D = 0, M = 8, P_0 = 180, Sn = 100, V_0 = 1, V_b = 138, Vn = 138, ra = 0.001, x1d = 0.2)  annotation(
    Placement(visible = true, transformation(origin = {60, -60}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus1(P_0 = 65, Q_0 = 30, V_0 = 1.04, V_b = 138, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-80, 42}, extent = {{-12, -12}, {12, 12}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(P_0 = 115, Q_0 = 60, V_0 = 1, V_b = 138, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {60, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus4(P_0 = 70, Q_0 = 30, V_0 = 1.00, V_b = 138, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-75, -63}, extent = {{-13, -13}, {13, 13}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus5(P_0 = 85, Q_0 = 40, V_0 = 1, V_b = 138, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-80, -18}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1_2(B = 0, G = 0, R = 0.042, X = 0.168)  annotation(
    Placement(visible = true, transformation(origin = {-8, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1_5(B = 0, G = 0, R = 0.031, X = 0.126)  annotation(
    Placement(visible = true, transformation(origin = {-84, 16}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4_5(B = 0, G = 0, R = 0.063, X = 0.252)  annotation(
    Placement(visible = true, transformation(origin = {-76, -34}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3_5(B = 0, G = 0, R = 0.053, X = 0.210)  annotation(
    Placement(visible = true, transformation(origin = {-4, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2_3(B = 0, G = 0, R = 0.031, X = 0.126)  annotation(
    Placement(visible = true, transformation(origin = {68, 12}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3_4(B = 0, G = 0, R = 0.084, X = 0.336)  annotation(
    Placement(visible = true, transformation(origin = {-2, -36}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus3(P_0 = 70, Q_0 = 40, V_0 = 1.02, V_b = 138, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {60, -12}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1(P_0 = 65, Q_0 = 30, V_0 = 1.04, V_b = 138, angle_0 = 0)  annotation(
    Placement(visible = true, transformation(origin = {-70, 58}, extent = {{-6, 6}, {6, -6}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2(P_0 = 115, Q_0 = 60, V_0 = 1, V_b = 138, angle_0 = 0)  annotation(
    Placement(visible = true, transformation(origin = {60, 62}, extent = {{-6, 6}, {6, -6}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant3(P_0 = 70, Q_0 = 40, V_0 = 1.02, V_b = 138, angle_0 = 0)  annotation(
    Placement(visible = true, transformation(origin = {67, -35}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant4(P_0 = 70, Q_0 = 30, V_0 = 1, V_b = 138, angle_0 = 0)  annotation(
    Placement(visible = true, transformation(origin = {-78, -90}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant5(P_0 = 85, Q_0 = 40, V_0 = 1, V_b = 138, angle_0 = 0)  annotation(
    Placement(visible = true, transformation(origin = {-87, -47}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));

 


equation
  connect(pwLine4_5.n, bus4.p) annotation(
    Line(points = {{-76, -42}, {-76, -42}, {-76, -62}, {-74, -62}}, color = {0, 0, 255}));
  connect(bus5.p, pwLine4_5.p) annotation(
    Line(points = {{-80, -18}, {-80, -19.5}, {-76, -19.5}, {-76, -25}}, color = {0, 0, 255}));
  connect(bus2.p, voltDependant2.p) annotation(
    Line(points = {{60, 42}, {60, 56}}, color = {0, 0, 255}));
  connect(bus3.p, voltDependant3.p) annotation(
    Line(points = {{60, -12}, {67, -12}, {67, -30}}, color = {0, 0, 255}));
 connect(bus1.p, pwLine1_2.p) annotation(
    Line(points = {{-80, 42}, {-80, 30}, {-17, 30}}, color = {0, 0, 255}));
 connect(pwLine1_2.n, bus2.p) annotation(
    Line(points = {{1, 30}, {60, 30}, {60, 42}}, color = {0, 0, 255}));
  connect(pwLine3_4.p, bus4.p) annotation(
    Line(points = {{-2, -46}, {-2, -52}, {-66, -52}, {-66, -63}, {-75, -63}}, color = {0, 0, 255}));
  connect(bus4.p, voltDependant4.p) annotation(
    Line(points = {{-75, -63}, {-78, -63}, {-78, -84}}, color = {0, 0, 255}));
  Y21= -(1/(Complex(pwLine1_2.R,pwLine1_2.X)));
  Y21_abs = sqrt(Y21.re ^ 2 + Y21.im ^ 2);
  Y21_arg = (atan(Y21.im /( Y21.re)))+pi;
  Y23= -(1/(Complex(pwLine2_3.R,pwLine2_3.X)));
  Y23_abs = sqrt(Y23.re ^ 2 + Y23.im ^ 2);
  Y23_arg = (atan(Y23.im / Y23.re))+pi;
//Y22= -Y21-Y23;
// Y22_abs = (Y22.re ^ 2 + Y22.im ^ 2) ^ 0.5;
///Y22_arg = atan(Y22.im / Y22.re);
//Y22_arg1= Y22_arg+pi;
  P2_cal = (bus2.V_0 * bus1.V_0 - bus2.V_0 * bus2.V_0) * Y21_abs * cos(Y21_arg) - (bus2.V_0 * bus2.V_0 - bus2.V_0 * bus3.V_0) * Y23_abs * cos(Y23_arg);
  Ps= -(bus2.P_0/SysData.S_b);
  P2_del= Ps-P2_cal;
  P2_d3= -(bus2.V_0*bus3.V_0*Y23_abs*sin(Y23_arg));
  connect(bus1.p, voltDependant1.p) annotation(
    Line(points = {{-80, 42}, {-70, 42}, {-70, 52}}, color = {0, 0, 255}));
  connect(bus5.p, voltDependant5.p) annotation(
    Line(points = {{-80, -18}, {-86, -18}, {-86, -42}, {-86, -42}}, color = {0, 0, 255}));
  connect(pwLine3_4.n, bus3.p) annotation(
    Line(points = {{-2, -27}, {-2, -20}, {54, -20}, {54, -12}, {60, -12}}, color = {0, 0, 255}));
  connect(pwLine2_3.n, bus3.p) annotation(
    Line(points = {{68, 2}, {68, 2}, {68, -12}, {60, -12}, {60, -12}}, color = {0, 0, 255}));
  connect(pwLine2_3.p, bus2.p) annotation(
    Line(points = {{68, 21}, {68, 42}, {60, 42}}, color = {0, 0, 255}));
  connect(pwLine3_5.n, bus3.p) annotation(
    Line(points = {{5, 2}, {52, 2}, {52, -12}, {60, -12}}, color = {0, 0, 255}));
 connect(bus3.p, generator2.p) annotation(
    Line(points = {{60, -12}, {60, -50}}, color = {0, 0, 255}));
  connect(bus5.p, pwLine3_5.p) annotation(
    Line(points = {{-80, -18}, {-71.125, -18}, {-71.125, 2}, {-13, 2}}, color = {0, 0, 255}));
  connect(pwLine1_5.n, bus5.p) annotation(
    Line(points = {{-84, 7}, {-84, -18}, {-80, -18}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1_5.p) annotation(
    Line(points = {{-80, 42}, {-84, 42}, {-84, 25}}, color = {0, 0, 255}));
 connect(generator1.p, bus1.p) annotation(
    Line(points = {{-80, 66}, {-80, 42}}, color = {0, 0, 255}));
 connect(generator1.pm, generator1.pm0) annotation(
    Line(points = {{-85, 88}, {-83, 88}, {-83, 98}, {-95, 98}, {-95, 84}, {-91, 84}, {-91, 84}}, color = {0, 0, 127}));
 connect(generator1.vf, generator1.vf0) annotation(
    Line(points = {{-75, 88}, {-75, 88}, {-75, 96}, {-63, 96}, {-63, 84}, {-69, 84}, {-69, 84}}, color = {0, 0, 127}));
 connect(generator2.vf, generator2.vf0) annotation(
    Line(points = {{54, -72}, {56, -72}, {56, -84}, {44, -84}, {44, -68}, {48, -68}, {48, -68}}, color = {0, 0, 127}));
 connect(generator2.pm, generator2.pm0) annotation(
    Line(points = {{66, -72}, {66, -72}, {66, -82}, {80, -82}, {80, -68}, {72, -68}, {72, -68}}, color = {0, 0, 127}));
//"The  answer may slightly vary due to  rounding off values"
end Ex8_1;
