model Ex9_1

  OpenIPSL.Types.ActivePowerMega P2 "plant output of Unit 2 for cost of unit 1 at min load";
  OpenIPSL.Types.ActivePowerMega P1 "Plant output of unit 1";
  OpenIPSL.Types.ActivePowerMega P "Total Plant output";
  Real lambda (final unit= "$/MWhr") "incremental fuel cost";
  
  parameter OpenIPSL.Types.ActivePowerMega Pmin= 100 "minimum load for each unit";
  parameter OpenIPSL.Types.ActivePowerMega Pmax= 625 "maximum load for each unit";
  
equation
  P1= Pmin;
  lambda= 0.008*P1+8.0;
  P2= (lambda-6.4)/0.0096;
  P= P1+P2;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex9_1;
