model Ex9_4

  Complex S1 "total power in bus 1";
  Complex S2 "total power in bus 2";
  Real P1 (final unit= "per unit") "Real power in bus 1 (model in ex_9_3)(pu)";
  Real P2 (final unit= "per unit") "Real power in bus 2 (model in ex_9_3)(pu)";
  Real Pl (final unit= "per unit") "Real power loss(pu)";
  
  parameter Complex I1= Complex(1, 0) "same as in Ex_9_3";
  parameter Complex V1= Complex(1.04, 0.16) "same as in Ex_9_3";
  parameter Complex I2= Complex(0.8, 0) "same as in Ex_9_3";
  parameter Complex V2= Complex(1.024, 0.096) "same as in Ex_9_3";
  parameter Real B11 (final unit= "per unit")= 0.0554 "loss coefficients obtained from Ex_9_3";
  parameter Real B12 (final unit= "per unit")= 0.0188 "loss coefficients obtained from Ex_9_3";
  parameter Real B22 (final unit= "per unit")= 0.047 "loss coefficients obtained from Ex_9_3";
  
equation 
  S1= I1*V1;
  S2= I2*V2;
  P1= S1.re;
  P2= S2.re;
  Pl= ((P1^2)*B11)+((2*P1*P2*B12))+((P2^2)*B22);
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex9_4;
