model Ex9_5

 OpenIPSL.Types.ActivePowerMega Pl "Power loss in transmission (MW)";
 OpenIPSL.Types.ActivePowerMega Pr "Delivered Load (MW)";
 OpenIPSL.Types.ActivePowerMega P1 "power in plant 1 (MW)";
 OpenIPSL.Types.ActivePowerMega P2 "power in plant 2 (MW)";
 OpenIPSL.Types.ActivePowerMega L1 "penaltry factor";
 OpenIPSL.Types.ActivePowerMega B11 "Loss coefficient";
 parameter OpenIPSL.Types.ActivePowerMega P1_2= 200 "power from plant 1 to 2 in MW";
 parameter OpenIPSL.Types.ActivePowerMega Pl1= 16 "power loss in transmission in MW";
 parameter Real B22 (final unit= "per unit")= 0 "loss coefficient";
 parameter Real B12 (final unit= "per unit")= 0 "loss coefficient";
 parameter Real lambda (final unit= "$/MWhr")= 12.5 "cost of the system";
 
equation
  B11= Pl1/(P1_2^2);
  P1= (lambda-8.5)/(0.01+2*B11*lambda);
  P2= (lambda-9.5)/0.015;
  L1= 1/(1-2*B11*lambda);
  Pl= B11*(P1^2);
  Pr= P1+P2-Pl;
  
//"The  answer may slightly vary due to  rounding off values" 

end Ex9_5;
