model Ex10_4

  Complex [5,5]Y_bus "admittance of bus network";
  Complex [5,5]Z_bus "impedance of bus";
  Complex I2 "subtransient current in a three-phase fault on bus 4(pu)";
  Complex V3 "voltages at bus 3 due to three phase fault at bus 4";
  Complex V5 "voltages at bus 5 due to three phase fault at bus 4";
  Complex I3 "Currents to the faults from bus 3";
  Complex I5 "Currents to the faults from bus 5";
  Complex I "total current to fault from bus 3 & 5";
  
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50)  annotation(
    Placement(visible = true, transformation(origin = {-85, 84}, extent = {{-15, -14}, {15, 14}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus4(V_0 = 1,V_b = 25, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {7, -13}, extent = {{-9, -9}, {9, 9}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1,V_b = 25, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-52, 4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_0 = 1,V_b = 25, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-26, 12}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_0 = 1,V_b = 25, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {52, 4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus5(V_0 = 1,V_b = 25, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-26, -8}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine12(B = 0, G = 0, R = 0.1, X = (1/5.952)) annotation(
    Placement(visible = true, transformation(origin = {-38, 12}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine23(B = 0, G = 0, R = 0.1, X = (1/7.937)) annotation(
    Placement(visible = true, transformation(origin = {3, 13}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine54(B = 0, G = 0, R = 0.1, X = (1/3.968)) annotation(
    Placement(visible = true, transformation(origin = {-8, -14}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine15(B = 0, G = 0, R = 0.1, X = (1/7.937)) annotation(
    Placement(visible = true, transformation(origin = {-38, -4}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine53(B = 0, G = 0, R = 0.1, X = (1/4.762)) annotation(
    Placement(visible = true, transformation(origin = {4, 2}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine43(B = 0, G = 0, R = 0.1, X = (1/2.976)) annotation(
    Placement(visible = true, transformation(origin = {29, -7}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 0.3, t1 = 15, t2 = 45) annotation(
    Placement(visible = true, transformation(origin = {18, -42}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3gen(B = 0, G = 0, R = 0, X = (1/7.5)) annotation(
    Placement(visible = true, transformation(origin = {63, 5}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = 270, V_0 = 1, V_b = 25, Vn = 25, ra = 0.001, x1d = 0.3*(100/270))  annotation(
    Placement(visible = true, transformation(origin = {-86, -5.55112e-16}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator2(D = 0, M = 8, Sn = 225, V_0 = 1, V_b = 25, Vn = 25, ra = 0.001, x1d = 0.3*(100/225))  annotation(
    Placement(visible = true, transformation(origin = {89, 5}, extent = {{7, -7}, {-7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1gen(B = 0, G = 0, R = 0, X = (1/9))  annotation(
    Placement(visible = true, transformation(origin = {-64, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));

  parameter Complex Y1d_gen1= Complex(0, -1/(pwLine1gen.X));
  parameter Complex Y1d_gen2= Complex(0, -1/(pwLine3gen.X));
  parameter Complex Y12= Complex(0, -1/(pwLine12.X)) "mutual admittance between bus 1 and 2";
  parameter Complex Y15= Complex(0, -1/(pwLine15.X)) "mutual admittance between bus 1 and 5";
  parameter Complex Y13= Complex(0, 0) "mutual admittance between bus 1 and 3";
  parameter Complex Y14= Complex(0, 0) "mutual admittance between bus 1 and 4";
  parameter Complex Y11= Y1d_gen1+Y12+Y15 "self admittance of bus 1";
  parameter Complex Y21= Y12 "mutual admittance between bus 2 and 1";
  parameter Complex Y23= Complex(0, -1/(pwLine23.X)) "mutual admittance between bus 2 and 3";
  parameter Complex Y24= Complex(0, 0) "mutual admittance between bus 2 and 4";
  parameter Complex Y25= Complex(0, 0) "mutual admittance between bus 2 and 5";
  parameter Complex Y22= Y21+Y23 "self admittance of bus 2";
  parameter Complex Y32= Y23 "mutual admittance between bus 3 and 2";
  parameter Complex Y34= Complex(0, -1/(pwLine43.X)) "mutual admittance between bus 3 and 4";
  parameter Complex Y35= Complex(0, -1/(pwLine53.X)) "mutual admittance between bus 3 and 5";
  parameter Complex Y31= Complex(0, 0) "mutual admittance between bus 3 and 1";
  parameter Complex Y33= Y1d_gen2+Y34+Y35+Y32 "self admittance of bus 3";
  parameter Complex Y43= Y34 "mutual admittance between bus 4 and 3";
  parameter Complex Y45= Complex(0, -1/(pwLine54.X)) "mutual admittance between bus 4 and 5";
  parameter Complex Y42= Complex(0, 0) "mutual admittance between bus 4 and 5";
  parameter Complex Y41= Complex(0, 0) "mutual admittance between bus 4 and 1";
  parameter Complex Y44= Y43+Y45 "self admittance of bus 4";
  parameter Complex Y54= Y45 "mutual admittance between bus 5 and 4";
  parameter Complex Y51= Y15 "mutual admittance between bus 5 and 1";
  parameter Complex Y53= Y35 "mutual admittance between bus 5 and 3";
  parameter Complex Y52= Complex(0, 0) "mutual admittance between bus 5 and 2";
  parameter Complex Y55= Y54+Y51+Y53 "self admittance of bus 5";  
  
equation
  connect(pwFault1.p, bus4.p) annotation(
    Line(points = {{18, -35}, {18, -16}, {7, -16}, {7, -13}}, color = {0, 0, 255}));
  connect(pwLine43.p, bus4.p) annotation(
    Line(points = {{22, -6}, {8, -6}, {8, -12}, {8, -12}, {8, -12}}, color = {0, 0, 255}));
  connect(pwLine43.n, bus3.p) annotation(
    Line(points = {{35, -7}, {46, -7}, {46, -2}, {52, -2}, {52, 4}}, color = {0, 0, 255}));
  connect(pwLine53.p, bus5.p) annotation(
    Line(points = {{-2, 2}, {-11, 2}, {-11, -6}, {-26, -6}, {-26, -8}}, color = {0, 0, 255}));
  connect(pwLine54.n, bus4.p) annotation(
    Line(points = {{-3, -14}, {-2.5, -14}, {-2.5, -13}, {7, -13}}, color = {0, 0, 255}));
  connect(pwLine54.p, bus5.p) annotation(
    Line(points = {{-13, -14}, {-26, -14}, {-26, -8}}, color = {0, 0, 255}));
  connect(pwLine53.n, bus3.p) annotation(
    Line(points = {{10, 2}, {52, 2}, {52, 4}, {52, 4}}, color = {0, 0, 255}));
  connect(pwLine23.n, bus3.p) annotation(
    Line(points = {{9, 13}, {52, 13}, {52, 4}}, color = {0, 0, 255}));
  connect(pwLine3gen.p, bus3.p) annotation(
    Line(points = {{57, 5}, {57, 4}, {52, 4}}, color = {0, 0, 255}));
  connect(pwLine15.n, bus5.p) annotation(
    Line(points = {{-33, -4}, {-26, -4}, {-26, -8}}, color = {0, 0, 255}));
  connect(pwLine12.n, bus2.p) annotation(
    Line(points = {{-33, 12}, {-26, 12}}, color = {0, 0, 255}));
  connect(pwLine23.p, bus2.p) annotation(
    Line(points = {{-3, 13}, {-3, 12}, {-26, 12}}, color = {0, 0, 255}));
  connect(generator1.pm, generator1.pm0) annotation(
    Line(points = {{-96, -4}, {-97.8, -4}, {-97.8, -12.5}, {-92, -12.5}, {-92, -9}}, color = {0, 0, 127}));
  connect(generator1.vf, generator1.vf0) annotation(
    Line(points = {{-96, 4}, {-97.8, 4}, {-97.8, 14.5}, {-92, 14.5}, {-92, 9}}, color = {0, 0, 127}));
  connect(generator1.p, pwLine1gen.p) annotation(
    Line(points = {{-78, 0}, {-70, 0}}, color = {0, 0, 255}));
  connect(generator2.pm0, generator2.pm) annotation(
    Line(points = {{94.6, -2.7}, {96.6, -2.7}, {96.6, -8.7}, {98.6, -8.7}, {98.6, 1.3}, {98.6, 1.3}, {98.6, 1.3}}, color = {0, 0, 127}));
  connect(generator2.vf, generator2.vf0) annotation(
    Line(points = {{97.4, 8.5}, {97.4, 8.5}, {97.4, 18.5}, {93.4, 18.5}, {93.4, 12.5}, {93.4, 12.5}}, color = {0, 0, 127}));
  connect(pwLine3gen.n, generator2.p) annotation(
    Line(points = {{69, 5}, {82, 5}}, color = {0, 0, 255}));
  connect(pwLine15.p, bus1.p) annotation(
    Line(points = {{-43, -4}, {-52, -4}, {-52, 4}}, color = {0, 0, 255}));
  connect(pwLine1gen.n, bus1.p) annotation(
    Line(points = {{-58, 0}, {-52, 0}, {-52, 4}}, color = {0, 0, 255}));
  connect(pwLine12.p, bus1.p) annotation(
    Line(points = {{-43, 12}, {-52, 12}, {-52, 4}}, color = {0, 0, 255}));
  
  Y_bus= {{Y11,-Y12,-Y13,-Y14,-Y15}, {-Y21,Y22,-Y23,-Y24,-Y25}, {-Y31,-Y32,Y33,-Y34,-Y35}, {-Y41,-Y42,-Y43,Y44,-Y45}, {-Y51,-Y52,-Y53,-Y54,Y55}};
  Z_bus= Complex(0, -Modelica.Math.Matrices.inv(Y_bus.im));
  I2= bus4.V_0/Z_bus[4,4];
  V3= bus3.V_0-(I2*Z_bus[3,4]);
  V5= bus5.V_0-(I2*Z_bus[5,4]);
  I3= V3*Y34;
  I5= V5*Y54;
  I= I3+I5;
//"The  answer may slightly vary due to  rounding off values"
end Ex10_4;
