model Ex12_4

  Modelica.SIunits.Current Ib_mot "Base curren t of motor circuit in A";
  Modelica.SIunits.Current Iac_mot "actual motor current in A";
  Complex Ia_pu "per unit current drawn by the motor through line a before the fault";
  Real Ia_pu_abs (final unit= "per unit") "magnitude of Ia_pu";
  Modelica.SIunits.Angle Ia_pu_arg "argument of Ia_pu";
  Complex Z1 "thevenin equivalent of positive sequence network";
  Complex Z2 "thevenin equivalent of negative sequence network";
  Complex Z0 "thevenin equivalent of zero sequence network";
  Complex Ia1 "line current in line a for positive sequence network";
  Complex Ia2 "line current in line a for negative sequence network"; 
  Complex Ia0 "line current in line a for zero sequence network";
  Complex In "current in fault in line a";
  Real In_abs (final unit= "per unit") "magnitude of In";
  Complex Ia1_tr2P "component of Ia1 flowing toward fault from transformer";
  Complex Ia2_tr2P "component of Ia2 flowing toward fault from transformer";
  Complex Ia0_tr2P "component of Ia0 flowing toward fault from transformer";
  Complex Ia1_P2tr "component of Ia1 flowing toward motor from fault";
  Complex Ia2_P2tr "component of Ia2 flowing toward motor from fault";
  Complex Ia0_P2tr "component of Ia0 flowing toward motor from fault";
  Complex Ia_tr2P "current in line a to fault from transformer";
  Complex Ib_tr2P "current in line b to fault from transformer";
  Complex Ic_tr2P "current in line c to fault from transformer";
  Real Ia_tr2P_abs (final unit= "per unit") "magnitude of Ia_tr2P";
  Real Ib_tr2P_abs (final unit= "per unit") "magnitude of Ib_tr2P";
  Real Ic_tr2P_abs (final unit= "per unit") "magnitude of Ic_tr2P";
  Complex Ia_P2tr "current in line a to fault from motor"; 
  Complex Ib_P2tr "current in line b to fault from motor";
  Complex Ic_P2tr "current in line c to fault from motor";
  Real Ia_P2tr_abs (final unit= "per unit") "magnitude of Ia_P2tr";
  Real Ib_P2tr_abs (final unit= "per unit") "magnitude of Ib_P2tr";
  Real Ic_P2tr_abs (final unit= "per unit") "magnitude of Ic_P2tr";
  Complex I_A1 "positive sequence network current on high tension side of the transformer";
  Complex I_A2 "negative sequence network current on high tension side of the transformer";
  Complex I_A0 "zero sequence network current on high tension side of the transformer";
  Complex I_A "current in line a on high tension side of tranformer";
  Complex I_B "current in line b on high tension side of tranformer";
  Complex I_C "current in line c on high tension side of tranformer";
  Real I_A_abs (final unit= "per unit") "magnitude of I_A";
  Real I_B_abs (final unit= "per unit") "magnitude of I_B";
  Real I_C_abs (final unit= "per unit") "magnitude of I_C";
  Modelica.SIunits.Current Ib_HT "base current fot H-T circuit";
  Modelica.SIunits.Current If "current in the fault";
  Modelica.SIunits.Current Iaf_trf "current in line a between transformer and fault";
  Modelica.SIunits.Current Ibf_trf "current in line b between transformer and fault";
  Modelica.SIunits.Current Icf_trf "current in line c between transformer and fault";
  Modelica.SIunits.Current Iaf_trm "current in line a between motor and fault";
  Modelica.SIunits.Current Ibf_trm "current in line a between motor and fault";
  Modelica.SIunits.Current Icf_trm "current in line a between motor and fault";
  Modelica.SIunits.Current Ia_bus1_tr "current in line a between bus and fault";
  Modelica.SIunits.Current Ib_bus1_tr "current in line b between bus and fault";
  Modelica.SIunits.Current Ic_bus1_tr "current in line c between bus and fault";

  OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, Sn = 7.5, V_0 = 1, V_b = 4.16, Vn = 4.16, ra = 0.001, x1d = 0.1)  annotation(
    Placement(visible = true, transformation(origin = {-168, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 7.5)  annotation(
    Placement(visible = true, transformation(origin = {-169, 72}, extent = {{-19, -20}, {19, 20}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order22(D = 0, M = 8, Sn = 4476e-3/0.895, V_0 = 0.144, V_b = 4.16, Vn = 0.6, ra = 0.001, x1d = 0.2)  annotation(
    Placement(visible = true, transformation(origin = {148, 12}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1, V_b = 4.16, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {1, 1}, extent = {{-11, -11}, {11, 11}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_0 = 1,V_b = 4.16, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-128, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = 0.01)  annotation(
    Placement(visible = true, transformation(origin = {-100, 0}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(kT = 6.93, r = 0, x = 0.1)  annotation(
    Placement(visible = true, transformation(origin = {-68, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 0.2, t1 = 15, t2 = 45)  annotation(
    Placement(visible = true, transformation(origin = {-52, -38}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));

  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Complex j= Complex(0, 1) "j is considered as a complex number with magnitude 1";
  parameter Real eta1= 0.895 "efficiency";
  parameter Real X_1 (final unit= "per unit")= 0.2 "positive sequence reactance of each motor on the motor base";
  parameter Complex X_11= Complex(0, X_1);
  parameter Real X_2 (final unit= "per unit")= 0.2 "negative sequence reactance of each motor on the motor base";
  parameter Complex X_22= Complex(0, X_2);
  parameter Real X_0 (final unit= "per unit")= 0.04 "zero sequence reactance of each motor on the motor base";
  parameter Real Xn_mot (final unit= "per unit")= 0.02 "zero sequence reactance of each motor on the motor base w.r.t ground";
  parameter Real Xn_gen (final unit= "per unit")= 0.05 "zero sequence reactance of the generator w.r.t ground";
  parameter Complex Z_1= Complex(0, X_1*(SysData.S_b/order22.Sn)) "positive sequence reactance of each motor on selected base";
  parameter Complex Z_2= Complex(0, X_2*(SysData.S_b/order22.Sn)) "negative sequence reactance of each motor on selected base";
  parameter Complex Z_0= Complex(0, X_0*(SysData.S_b/order22.Sn)) "zero sequence reactance of each motor on selected base";
  parameter Complex Zn_mot= Complex(0, 3*Xn_mot*(SysData.S_b/order22.Sn))"zero sequence reactance of each motor on selcted base w.r.t ground";
  parameter Complex Z_tr= Complex(0, twoWindingTransformer1.x);
  parameter Complex Z_gen= Complex(0, order21.x1d);
  parameter Complex Zn_gen= Complex(0, 3*Xn_gen);
  parameter Real Vf (final unit= "per unit")= 1.0 "fault voltage";
  parameter Real eta2= 0.88 "efficiency";
  parameter Real pf= 0.85 "power factor";
  parameter Complex a= Complex(1*cos(120*D2R), 1*sin(120*D2R)) "operator";
  parameter Complex a2= Complex(1*cos(240*D2R), 1*sin(240*D2R)) "operator";
 OpenIPSL.Electrical.Machines.PSAT.Order2 order23(D = 0, M = 8, Sn = 4476e-3/0.895, V_0 = 0.144, V_b = 4.16, Vn = 0.6, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {154, 60}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Machines.PSAT.Order2 order24(D = 0, M = 8, Sn = 4476e-3/0.895, V_0 = 0.144, V_b = 4.16, Vn = 0.6, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {148, -28}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Machines.PSAT.Order2 order25(D = 0, M = 8, Sn = 4476e-3/0.895, V_0 = 0.144, V_b = 4.16, Vn = 0.6, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {146, -72}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.01)  annotation(
    Placement(visible = true, transformation(origin = {86, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.01)  annotation(
    Placement(visible = true, transformation(origin = {86, 12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0, G = 0, R = 0, X = 0.01)  annotation(
    Placement(visible = true, transformation(origin = {88, -28}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Branches.PwLine pwLine5(B = 0, G = 0, R = 0, X = 0.01)  annotation(
    Placement(visible = true, transformation(origin = {88, -72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
 OpenIPSL.Electrical.Branches.PwLine pwLine6(B = 0, G = 0, R = 0, X = 0.01)  annotation(
    Placement(visible = true, transformation(origin = {-24, 0}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
equation
  connect(order21.pm, order21.pm0) annotation(
    Line(points = {{-180, -5}, {-190, -5}, {-190, -21}, {-176, -21}, {-176, -11}}, color = {0, 0, 127}));
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-180, 5}, {-192, 5}, {-192, 23}, {-176, 23}, {-176, 11}}, color = {0, 0, 127}));
  connect(order25.pm, order25.pm0) annotation(
    Line(points = {{158, -77}, {172, -77}, {172, -89}, {154, -89}, {154, -83}}, color = {0, 0, 127}));
  connect(order25.vf0, order25.vf) annotation(
    Line(points = {{154, -61}, {158, -61}, {158, -55}, {172, -55}, {172, -67}, {158, -67}}, color = {0, 0, 127}));
  connect(order24.vf0, order24.vf) annotation(
    Line(points = {{156, -17}, {158, -17}, {158, -13}, {172, -13}, {172, -23}, {160, -23}}, color = {0, 0, 127}));
  connect(order24.pm, order24.pm0) annotation(
    Line(points = {{160, -33}, {172, -33}, {172, -43}, {156, -43}, {156, -39}}, color = {0, 0, 127}));
  connect(order22.pm, order22.pm0) annotation(
    Line(points = {{160, 7}, {172, 7}, {172, -5}, {156, -5}, {156, 1}}, color = {0, 0, 127}));
  connect(order22.vf0, order22.vf) annotation(
    Line(points = {{156, 23}, {156, 29}, {172, 29}, {172, 17}, {160, 17}}, color = {0, 0, 127}));
  connect(pwLine5.n, order25.p) annotation(
    Line(points = {{97, -72}, {136, -72}}, color = {0, 0, 255}));
  connect(pwLine5.p, bus1.p) annotation(
    Line(points = {{79, -72}, {28, -72}, {28, 1}, {1, 1}}, color = {0, 0, 255}));
  connect(pwLine4.p, bus1.p) annotation(
    Line(points = {{79, -28}, {28, -28}, {28, 1}, {1, 1}}, color = {0, 0, 255}));
  connect(pwLine4.n, order24.p) annotation(
    Line(points = {{97, -28}, {138, -28}}, color = {0, 0, 255}));
  connect(pwLine3.n, order22.p) annotation(
    Line(points = {{95, 12}, {138, 12}}, color = {0, 0, 255}));
  connect(pwLine3.p, bus1.p) annotation(
    Line(points = {{77, 12}, {28, 12}, {28, 1}, {1, 1}}, color = {0, 0, 255}));
  connect(pwLine2.p, bus1.p) annotation(
    Line(points = {{77, 60}, {28, 60}, {28, 1}, {1, 1}}, color = {0, 0, 255}));
  connect(pwLine6.n, bus1.p) annotation(
    Line(points = {{-17, 0}, {1, 0}, {1, 1}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, pwLine6.p) annotation(
    Line(points = {{-57, 0}, {-31, 0}}, color = {0, 0, 255}));
  connect(pwFault1.p, twoWindingTransformer1.n) annotation(
    Line(points = {{-52, -31}, {-52, 0}, {-57, 0}}, color = {0, 0, 255}));
  connect(order23.pm, order23.pm0) annotation(
    Line(points = {{166, 55}, {178, 55}, {178, 43}, {162, 43}, {162, 49}}, color = {0, 0, 127}));
  connect(order23.vf0, order23.vf) annotation(
    Line(points = {{162, 71}, {162, 77}, {176, 77}, {176, 65}, {166, 65}}, color = {0, 0, 127}));
  connect(pwLine2.n, order23.p) annotation(
    Line(points = {{95, 60}, {144, 60}}, color = {0, 0, 255}));
  connect(pwLine1.n, twoWindingTransformer1.p) annotation(
    Line(points = {{-93, 0}, {-79, 0}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine1.p) annotation(
    Line(points = {{-128, 0}, {-107, 0}}, color = {0, 0, 255}));
  connect(order21.p, bus2.p) annotation(
    Line(points = {{-158, 0}, {-128, 0}}, color = {0, 0, 255}));
  Ib_mot = SysData.S_b * 1e6 / (order22.Vn * 1e3 * sqrt(3));
  Iac_mot = 746 * order22.Sn * 1e3 / (eta2 * pf * order22.Vn * 1e3 * sqrt(3));
  Ia_pu = Complex(Iac_mot / Ib_mot * cos(-acos(pf)), Iac_mot / Ib_mot * sin(-acos(pf)));
  Ia_pu_abs = sqrt(Ia_pu.re ^ 2 + Ia_pu.im ^ 2);
  Ia_pu_arg = atan(Ia_pu.im / Ia_pu.re);
  Z1 = (Z_tr + Z_gen) * Z_1 / (Z_tr + Z_gen + Z_1);
  Z2 = (Z_tr + Z_gen) * Z_2 / (Z_tr + Z_gen + Z_2);
  Z0 = Zn_gen;
  Ia1 = Vf / (Z1 + Z2 + Z0);
  Ia2 = Ia1;
  Ia0 = Ia2;
  In = 3 * Ia0;
  In_abs = sqrt(In.re ^ 2 + In.im ^ 2);
  Ia1_tr2P = Ia1 * Z_1 / (Z_1 + X_11);
  Ia2_tr2P = Ia2 * Z_2 / (Z_2 + X_22);
  Ia0_tr2P = Complex(0, 0);
  Ia1_P2tr = Ia1 * X_11 / (Z_1 + X_11);
  Ia2_P2tr = Ia2 * X_22 / (Z_2 + X_22);
  Ia0_P2tr = Ia0;
  Ia_tr2P = Ia0_tr2P + Ia1_tr2P + Ia2_tr2P;
  Ib_tr2P = Ia0_tr2P + a2 * Ia1_tr2P + a * Ia2_tr2P;
  Ic_tr2P = Ia0_tr2P + a * Ia1_tr2P + a2 * Ia2_tr2P;
  Ia_tr2P_abs = sqrt(Ia_tr2P.re ^ 2 + Ia_tr2P.im ^ 2);
  Ib_tr2P_abs = sqrt(Ib_tr2P.re ^ 2 + Ib_tr2P.im ^ 2);
  Ic_tr2P_abs = sqrt(Ic_tr2P.re ^ 2 + Ic_tr2P.im ^ 2);
  Ia_P2tr = Ia0_P2tr + Ia1_P2tr + Ia2_P2tr;
  Ib_P2tr = Ia0_P2tr + a2 * Ia1_P2tr + a * Ia2_P2tr;
  Ic_P2tr = Ia0_P2tr + a * Ia1_P2tr + a2 * Ia2_P2tr;
  Ia_P2tr_abs = sqrt(Ia_P2tr.re ^ 2 + Ia_P2tr.im ^ 2);
  Ib_P2tr_abs = sqrt(Ib_P2tr.re ^ 2 + Ib_P2tr.im ^ 2);
  Ic_P2tr_abs = sqrt(Ic_P2tr.re ^ 2 + Ic_P2tr.im ^ 2);
  I_A1 = -j * Ia1_tr2P;
  I_A2 = j * Ia2_tr2P;
  I_A0 = Complex(0, 0);
  I_A = I_A0 + I_A1 + I_A2;
  I_B = a2 * I_A1 + a * I_A2 + I_A0;
  I_C = a * I_A1 + a2 * I_A2 + I_A0;
  I_A_abs = sqrt(I_A.re ^ 2 + I_A.im ^ 2);
  I_B_abs = sqrt(I_B.re ^ 2 + I_B.im ^ 2);
  I_C_abs = sqrt(I_C.re ^ 2 + I_C.im ^ 2);
  Ib_HT = SysData.S_b * 1e6 / (order22.V_b * 1e3 * sqrt(3));
  If = In_abs * Ib_mot;
  Iaf_trf = Ia_tr2P_abs * Ib_mot;
  Ibf_trf = Ib_tr2P_abs * Ib_mot;
  Icf_trf = Ic_tr2P_abs * Ib_mot;
  Iaf_trm = Ia_P2tr_abs * Ib_mot;
  Ibf_trm = Ib_P2tr_abs * Ib_mot;
  Icf_trm = Ic_P2tr_abs * Ib_mot;
  Ia_bus1_tr = I_A_abs * Ib_HT;
  Ib_bus1_tr = I_B_abs * Ib_HT;
  Ic_bus1_tr = I_C_abs * Ib_HT;
//"The  answer may slightly vary due to  rounding off values"
  annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex12_4;
