model Ex14_11
//refer Ex_14_9 & Ex_14_10
  Real Pe (final unit="per unit") "electrical power refer Ex_14_9";
  Real Pa (final unit="per unit") "accelerating power of machine";
  Real k (final unit="elec deg")"constant parameter";
  Real Pa_t0 (final unit="per unit") "average value of Pa at t=0";
  Real k_Pa (final unit="deg") "constant parameter";
  Real del1 (final unit="deg")"rotor angle at end of 1st interval";
  Real del_gama (final unit="deg")"rotor angle";
  Real k_Pa1 (final unit="deg");
  Real del2 (final unit="deg")"rotor angle over the end of 2nd time interval";
  Real del21 (final unit="deg")"rotor angle at the end of 2nd interval"; 
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Modelica.SIunits.Time t= 0.05 "time interval of fault";
  parameter Modelica.SIunits.Frequency f=60 "frequency of the system";
  parameter Modelica.SIunits.Angle del0= 16.19 "rotor angle when fault occurs";
  parameter Real H= 8.0 "inertia constant of the machine";
  parameter Modelica.SIunits.Angle gama= 0.755 "refer Ex_14_9";
 
equation
  k= (180*f/H)*(t^2);
  Pe= 0.1545+5.5023*sin((del0-0.755)*D2R);
  Pa= 1.6955-5.5023*sin((del0-0.755)*D2R);
  Pa_t0= 0.5*Pa;
  k_Pa= k*Pa_t0;
  del1= del0+k_Pa;
  del_gama= del1-gama;
  k_Pa1= k*(1.6955-5.5023*sin((del_gama*D2R)));
  del2= k_Pa+k_Pa1;
  del21= del2+del1;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex14_11;
