model Ex14_3
Real Pe(final unit = "per unit") "output power in pu";
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 500) annotation(
    Placement(visible = true, transformation(origin = {-88, 90}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = 500, V_0 = 1, V_b = 400, Vn = 400, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {-82, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_b = 400, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-28, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_b = 400, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {52, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1) annotation(
    Placement(visible = true, transformation(origin = {84, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 500, V_b = 400, Vn = 400, r = 0.0, x = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-46, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1 annotation(
    Placement(visible = true, transformation(origin = {-14, 8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2 annotation(
    Placement(visible = true, transformation(origin = {36, 8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker3 annotation(
    Placement(visible = true, transformation(origin = {-14, -8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker4 annotation(
    Placement(visible = true, transformation(origin = {36, -8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {8, 8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {8, -8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  constant Real pi = 2 * Modelica.Math.asin(1.0);
  constant Real D2R = pi / 180 "Degree to Radian";
  constant Real R2D = 180 / pi "Radian to Degree";
  parameter Complex Zeq1 = Complex(0, twoWindingTransformer1.x + pwLine2.X / 2) "series impeadnce between terminal voltage and infinite bus";
  parameter Real Pgen(final unit = "per unit") = 1.0 "power delivered by machine";
  parameter Modelica.SIunits.Angle alpha = asin(Pgen * Zeq1.im / (infiniteBus1.V_0 * generator1.V_0)) "angle of terminal voltage relative to infinite bus";
  parameter Complex Vt = Complex(generator1.V_0 * cos(alpha), generator1.V_0 * sin(alpha)) "terminal voltage";
  parameter Complex I = (Vt - infiniteBus1.V_0) / Zeq1 "output current in pu";
  parameter Real I_abs(final unit = "per unit") = sqrt(I.re ^ 2 + I.im ^ 2) "magnitude of I";
  parameter Modelica.SIunits.Angle I_arg = atan(I.im / I.re) "argument of I";
  parameter Complex E_1 = Vt + Complex(0, generator1.x1d) * I "transient internal voltage";
  parameter Real E_1_abs(final unit = "per unit") = sqrt(E_1.re ^ 2 + E_1.im ^ 2) "magnitude of E_1";
  parameter Modelica.SIunits.Angle E_1_arg = atan(E_1.im / E_1.re) "argumnet of E_1";
  parameter Real Xtot(final unit = "per unit") = generator1.x1d + twoWindingTransformer1.x + pwLine2.X / 2 "total series raectance";
  OpenIPSL.Electrical.Buses.Bus bus3(V_b = 400, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-64, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(bus3.p, generator1.p) annotation(
    Line(points = {{-64, 0}, {-72, 0}}, color = {0, 0, 255}));
  connect(bus3.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-64, 0}, {-56, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-35, 0}, {-28, 0}}, color = {0, 0, 255}));
  connect(pwLine2.n, breaker2.s) annotation(
    Line(points = {{17, 8}, {31, 8}}, color = {0, 0, 255}));
  connect(breaker2.r, bus2.p) annotation(
    Line(points = {{41, 8}, {52, 8}, {52, 0}}, color = {0, 0, 255}));
  connect(breaker1.s, bus1.p) annotation(
    Line(points = {{-19, 8}, {-28, 8}, {-28, 0}}, color = {0, 0, 255}));
  connect(breaker3.s, bus1.p) annotation(
    Line(points = {{-19, -8}, {-28, -8}, {-28, 0}}, color = {0, 0, 255}));
  connect(breaker3.r, pwLine3.p) annotation(
    Line(points = {{-9, -8}, {-1, -8}}, color = {0, 0, 255}));
  connect(breaker1.r, pwLine2.p) annotation(
    Line(points = {{-9, 8}, {-1, 8}}, color = {0, 0, 255}));
  connect(pwLine3.n, breaker4.s) annotation(
    Line(points = {{17, -8}, {31, -8}}, color = {0, 0, 255}));
  connect(breaker4.r, bus2.p) annotation(
    Line(points = {{41, -8}, {52, -8}, {52, 0}}, color = {0, 0, 255}));
  connect(bus2.p, infiniteBus1.p) annotation(
    Line(points = {{52, 0}, {94, 0}}, color = {0, 0, 255}));
  Pe = E_1_abs * infiniteBus1.V_0 / Xtot * sin(E_1_arg);
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-90, -12}, {-90, -12}, {-90, -22}, {-98, -22}, {-98, -4}, {-94, -4}, {-94, -6}}, color = {0, 0, 127}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-90, 12}, {-90, 12}, {-90, 20}, {-98, 20}, {-98, 4}, {-94, 4}, {-94, 6}}, color = {0, 0, 127}));
//"The  answer may slightly vary due to  rounding off values"
  annotation(
    Diagram,
    Icon,
    __OpenModelica_commandLineOptions = "");

end Ex14_3;
