model Ex14_4
 Real Pe(final unit = "per unit") "output power";
  Real Pa(final unit = "per unit") "initial accelerating power";
  Real D(final unit = "elc deg/s^2") "initial acceleration";
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 500, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-85, 87}, extent = {{-13, -11}, {13, 11}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 10, Sn = 500, V_0 = 1, V_b = 400, Vn = 400, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {-84, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_0 = 1, V_b = 400, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-36, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_0 = 1, V_b = 400, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {44, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1, V_b = 400) annotation(
    Placement(visible = true, transformation(origin = {88, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 500, V_b = 400, Vn = 400, kT = 1, r = 0.0, x = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-52, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-20, 8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {32, 8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker3(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-20, -8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker4(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {32, -8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0.15, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {6, 8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0.15, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {6, -8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  constant Real pi = 2 * Modelica.Math.asin(1.0);
  constant Real D2R = pi / 180 "Degree to Radian";
  constant Real R2D = 180 / pi "Radian to Degree";
  parameter Complex Zeq1 = Complex(0, twoWindingTransformer1.x + pwLine2.X / 2) "series impeadnce between terminal voltage and infinite bus";
  parameter Real Pgen(final unit = "per unit") = 1.0 "power delivered by machine";
  parameter Modelica.SIunits.Angle alpha = asin(Pgen * Zeq1.im / (infiniteBus1.V_0 * generator1.V_0)) "angle of terminal voltage relative to infinite bus";
  parameter Complex Vt = Complex(generator1.V_0 * cos(alpha), generator1.V_0 * sin(alpha)) "terminal voltage";
  parameter Complex I = (Vt - infiniteBus1.V_0) / Zeq1 "output current in pu";
  parameter Real I_abs(final unit = "per unit") = sqrt(I.re ^ 2 + I.im ^ 2) "magnitude of I";
  parameter Modelica.SIunits.Angle I_arg = atan(I.im / I.re) "argument of I";
  parameter Complex E_1 = Vt + Complex(0, generator1.x1d) * I "transient internal voltage";
  parameter Real E_1_abs(final unit = "per unit") = sqrt(E_1.re ^ 2 + E_1.im ^ 2) "magnitude of E_1";
  parameter Modelica.SIunits.Angle E_1_arg = atan(E_1.im / E_1.re) "argumnet of E_1";
  parameter Real Xtot(final unit = "per unit") = generator1.x1d + twoWindingTransformer1.x + pwLine2.X / 2 "total series raectance";
  parameter Complex[2, 2] Ybus = {{Complex(0, -2.308), Complex(0, 0.769)}, {Complex(0, 0.769), Complex(0, -6.923)}} "bus admittance matrix";
  parameter Real Pmax(final unit = "per unit") = E_1_abs * infiniteBus1.V_0 * Ybus[1, 2].im "max power";
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 0.12, t1 = 15, t2 = 45) annotation(
    Placement(visible = true, transformation(origin = {22, -50}, extent = {{-6, -6}, {6, 6}}, rotation = 270)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0.15, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {64, -6.66134e-16}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_0 = 1, V_b = 400, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-68, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(twoWindingTransformer1.p, bus3.p) annotation(
    Line(points = {{-63, 0}, {-68, 0}}, color = {0, 0, 255}));
  connect(generator1.p, bus3.p) annotation(
    Line(points = {{-74, 0}, {-68, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-41, 0}, {-36, 0}}, color = {0, 0, 255}));
  connect(pwLine3.n, pwFault1.p) annotation(
    Line(points = {{16, -8}, {22, -8}, {22, -43}}, color = {0, 0, 255}));
  connect(breaker1.s, bus1.p) annotation(
    Line(points = {{-25, 8}, {-36, 8}, {-36, 0}}, color = {0, 0, 255}));
  connect(breaker1.r, pwLine2.p) annotation(
    Line(points = {{-15, 8}, {-3, 8}}, color = {0, 0, 255}));
  connect(breaker3.s, bus1.p) annotation(
    Line(points = {{-25, -8}, {-36, -8}, {-36, 0}}, color = {0, 0, 255}));
  connect(breaker3.r, pwLine3.p) annotation(
    Line(points = {{-15, -8}, {-3, -8}}, color = {0, 0, 255}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-92, 11}, {-92, 11}, {-92, 19}, {-100, 19}, {-100, 3}, {-96, 3}, {-96, 5}}, color = {0, 0, 127}));
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-92, -11}, {-92, -11}, {-92, -21}, {-100, -21}, {-100, -3}, {-96, -3}, {-96, -5}}, color = {0, 0, 127}));
  connect(bus2.p, pwLine1.p) annotation(
    Line(points = {{44, 0}, {55, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, infiniteBus1.p) annotation(
    Line(points = {{73, 0}, {98, 0}}, color = {0, 0, 255}));
  connect(pwLine3.n, breaker4.s) annotation(
    Line(points = {{15, -8}, {27, -8}}, color = {0, 0, 255}));
  connect(breaker4.r, bus2.p) annotation(
    Line(points = {{37, -8}, {44, -8}, {44, 0}}, color = {0, 0, 255}));
  connect(breaker2.r, bus2.p) annotation(
    Line(points = {{37, 8}, {44, 8}, {44, 0}}, color = {0, 0, 255}));
  connect(pwLine2.n, breaker2.s) annotation(
    Line(points = {{15, 8}, {27, 8}}, color = {0, 0, 255}));
  Pe = Pmax * sin(E_1_arg);
  Pa = 1 - Pe;
  D = Pa * (180 * SysData.fn / 5);
//"The  answer may slightly vary due to  rounding off values"
  annotation(
    Diagram,
    Icon,
    __OpenModelica_commandLineOptions = "");

end Ex14_4;
