model Ex14_9
Complex Yl4 "admittance of bus 1-4";
  Complex Yl5 "admittance of bus 1-5";
  Complex Y11 "admittance of bus 1";
  Complex Y34 "admittance of bus 3-4";
  Complex Y44 "admittance of bus 4";
  Real Pe1(final unit = "per unit") "electrical power of generator 1";
  Real Pe2(final unit = "per unit") "electrical power of generator 2";
  Real D1(final unit = "elc deg/s^2") "acceleration of generator 1";
  Real D2(final unit = "elc deg/s^2") "acceleration of generator 2";
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 60) annotation(
    Placement(visible = true, transformation(origin = {-85, 60}, extent = {{-13, -12}, {13, 12}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(P_0 = 3.5 * SysData.S_b, Q_0 = 0.712 * SysData.S_b, V_0 = 1.030, V_b = 230, angle_0 = 8.88, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-68, 22}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(P_0 = 1.85 * SysData.S_b, Q_0 = 0.298 * SysData.S_b, V_0 = 1.020, V_b = 230, angle_0 = 6.38, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {4.44089e-16, -66}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_b = 230, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {55, 21}, extent = {{-9, -9}, {9, 9}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus4(P_0 = 1 * SysData.S_b, Q_0 = 0.44 * SysData.S_b, V_0 = 1.018, V_b = 230, angle_0 = 4.68, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-46, 22}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus5(P_0 = 0.5 * SysData.S_b, Q_0 = 0.16 * SysData.S_b, V_0 = 1.011, V_b = 230, angle_0 = 2.27, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-8.88178e-16, -42}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 22.4, Sn = 400, V_0 = 0.869, V_b = 230, Vn = 20, ra = 0.001, x1d = 0.067) annotation(
    Placement(visible = true, transformation(origin = {-82, 22}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_b = 230) annotation(
    Placement(visible = true, transformation(origin = {90, 21}, extent = {{-8, -7}, {8, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, x = 0.022) annotation(
    Placement(visible = true, transformation(origin = {-56, 22}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-26, 28}, extent = {{-2, -2}, {2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {38, 28}, extent = {{-2, -2}, {2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker3(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-30.5943, 20.4057}, extent = {{-2.4057, 2.5943}, {2.4057, -2.5943}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker4(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {30, 20}, extent = {{-2, -2}, {2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker5(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {40, 14}, extent = {{-2, -2}, {2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker7(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {0, -24}, extent = {{-2, -2}, {2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Events.Breaker breaker8(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {20, -24}, extent = {{-2, -2}, {2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, x = 0.04) annotation(
    Placement(visible = true, transformation(origin = {0, -56}, extent = {{-6, -6}, {6, 6}}, rotation = 90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator2(D = 0, M = 16, Sn = 250, V_0 = 0.0786, V_b = 230, Vn = 18, ra = 0.001, x1d = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-4.44089e-16, -82}, extent = {{-8, -8}, {8, 8}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0.082, G = 0, R = 0.007, X = 0.04) annotation(
    Placement(visible = true, transformation(origin = {0, 28}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0.226, G = 0, R = 0.018, X = 0.11) annotation(
    Placement(visible = true, transformation(origin = {-20, -4}, extent = {{-6, -6}, {6, 6}}, rotation = 90)));
  OpenIPSL.Electrical.Events.Breaker breaker6(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-20, -24}, extent = {{-2, -2}, {2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0.098, G = 0, R = 0.008, X = 0.047) annotation(
    Placement(visible = true, transformation(origin = {-6.66134e-16, -4}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0.098, G = 0, R = 0.008, X = 0.047) annotation(
    Placement(visible = true, transformation(origin = {20, -4}, extent = {{-6, -6}, {6, 6}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1(V_b = 230) annotation(
    Placement(visible = true, transformation(origin = {-28, -64}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2(V_b = 230) annotation(
    Placement(visible = true, transformation(origin = {-52, -64}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 0.2, t1 = 15, t2 = 45) annotation(
    Placement(visible = true, transformation(origin = {-30, -14}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  constant Real pi = 2 * Modelica.Math.asin(1.0);
  constant Real D2R = pi / 180 "Degree to Radian";
  constant Real R2D = 180 / pi "Radian to Degree";
  parameter Complex S1 = Complex(bus1.P_0 / SysData.S_b, -bus1.Q_0 / SysData.S_b) "power at generation side on bus1";
  parameter Complex V1 = Complex(bus1.V_0 * cos(bus1.angle_0 * D2R), bus1.V_0 * sin(bus1.angle_0 * D2R)) "voltage at generation side on bus1";
  parameter Complex V1_conj = Complex(V1.re, -V1.im);
  parameter Complex I1 = S1 / V1_conj "bus 1 current in pu";
  parameter Real I1_abs(final unit = "per unit") = sqrt(I1.re ^ 2 + I1.im ^ 2) "magnitude of I1";
  parameter Modelica.SIunits.Angle I1_arg = atan(I1.im / I1.re) "argument of I1";
  parameter Complex E1 = V1 + Complex(0, generator1.x1d) * I1 "bus 1 voltage";
  parameter Real E1_abs(final unit = "per unit") = sqrt(E1.re ^ 2 + E1.im ^ 2) "magnitude of E1";
  parameter Modelica.SIunits.Angle E1_arg = atan(E1.im / E1.re) "argument of E1";
  parameter Complex S2 = Complex(bus2.P_0 / SysData.S_b, -bus2.Q_0 / SysData.S_b) "power at generation side on bus2";
  parameter Complex V2 = Complex(bus2.V_0 * cos(bus2.angle_0 * D2R), bus2.V_0 * sin(bus2.angle_0 * D2R)) "voltage at generation side on bus2";
  parameter Complex V2_conj = Complex(V2.re, -V2.im);
  parameter Complex I2 = S2 / V2_conj "bus 2 current in pu";
  parameter Real I2_abs(final unit = "per unit") = sqrt(I2.re ^ 2 + I2.im ^ 2) "magnitude of I2";
  parameter Modelica.SIunits.Angle I2_arg = atan(I2.im / I2.re) "argument of I2";
  parameter Complex E2 = V2 + Complex(0, generator2.x1d) * I2 "bus 2 voltage";
  parameter Real E2_abs(final unit = "per unit") = sqrt(E2.re ^ 2 + E2.im ^ 2) "magnitude of E2";
  parameter Modelica.SIunits.Angle E2_arg = atan(E2.im / E2.re) "argument of E2";
  parameter Complex S4 = Complex(bus4.P_0 / SysData.S_b, -bus4.Q_0 / SysData.S_b) "power at load side on bus4";
  parameter Complex S5 = Complex(bus5.P_0 / SysData.S_b, -bus5.Q_0 / SysData.S_b) "power at load side on bus5";
equation
  connect(pwLine2.p, breaker6.r) annotation(
    Line(points = {{-20, -10}, {-20, -10}, {-20, -22}, {-20, -22}}, color = {0, 0, 255}));
  connect(breaker6.s, bus5.p) annotation(
    Line(points = {{-20, -26}, {-20, -26}, {-20, -34}, {-8, -34}, {-8, -42}, {0, -42}, {0, -42}}, color = {0, 0, 255}));
  connect(infiniteBus1.p, bus3.p) annotation(
    Line(points = {{98, 22}, {54, 22}, {54, 22}, {56, 22}}, color = {0, 0, 255}));
  connect(breaker7.s, bus5.p) annotation(
    Line(points = {{0, -26.5}, {0, -42}}, color = {0, 0, 255}));
  connect(pwLine3.n, breaker7.r) annotation(
    Line(points = {{0, -9}, {0, -21.5}}, color = {0, 0, 255}));
  connect(breaker8.s, bus5.p) annotation(
    Line(points = {{20, -26.5}, {20, -32}, {8, -32}, {8, -42}, {0, -42}}, color = {0, 0, 255}));
  connect(pwLine4.p, breaker8.r) annotation(
    Line(points = {{20, -9}, {20, -21.5}}, color = {0, 0, 255}));
  connect(breaker5.r, bus3.p) annotation(
    Line(points = {{45, 14}, {55, 14}, {55, 21}}, color = {0, 0, 255}));
  connect(breaker5.s, pwLine4.n) annotation(
    Line(points = {{35, 14}, {20, 14}, {20, 1}}, color = {0, 0, 255}));
  connect(breaker4.r, bus3.p) annotation(
    Line(points = {{32, 20}, {54, 20}, {54, 22}, {56, 22}}, color = {0, 0, 255}));
  connect(breaker4.s, pwLine3.p) annotation(
    Line(points = {{27.5, 20}, {0, 20}, {0, 1}}, color = {0, 0, 255}));
  connect(pwLine1.n, breaker2.s) annotation(
    Line(points = {{5, 28}, {35.5, 28}}, color = {0, 0, 255}));
  connect(breaker2.r, bus3.p) annotation(
    Line(points = {{40.5, 28}, {55, 28}, {55, 21}}, color = {0, 0, 255}));
  connect(breaker3.s, bus4.p) annotation(
    Line(points = {{-34, 20}, {-46, 20}, {-46, 22}}, color = {0, 0, 255}));
  connect(breaker3.r, pwLine2.n) annotation(
    Line(points = {{-28, 20}, {-20, 20}, {-20, 2}}, color = {0, 0, 255}));
  connect(pwFault1.p, bus4.p) annotation(
    Line(points = {{-34, -14}, {-38, -14}, {-38, 16}, {-38, 16}, {-38, 18}, {-46, 18}, {-46, 22}, {-46, 22}, {-46, 22}}, color = {0, 0, 255}));
  connect(voltDependant2.p, bus4.p) annotation(
    Line(points = {{-52, -60}, {-52, -60}, {-52, -48}, {-40, -48}, {-40, 16}, {-48, 16}, {-48, 16}, {-46, 16}, {-46, 22}, {-46, 22}}, color = {0, 0, 255}));
  connect(bus5.p, voltDependant1.p) annotation(
    Line(points = {{0, -42}, {-6, -42}, {-6, -50}, {-28, -50}, {-28, -60}, {-28, -60}}, color = {0, 0, 255}));
  connect(generator1.p, bus1.p) annotation(
    Line(points = {{-74, 22}, {-68, 22}}, color = {0, 0, 255}));
  connect(generator1.vf, generator1.vf0) annotation(
    Line(points = {{-91.6, 26}, {-95.6, 26}, {-95.6, 38}, {-87.6, 38}, {-87.6, 30}, {-87.6, 30}, {-87.6, 30}}, color = {0, 0, 127}));
  connect(generator1.pm, generator1.pm0) annotation(
    Line(points = {{-91.6, 18}, {-95.6, 18}, {-95.6, 8}, {-87.6, 8}, {-87.6, 14}, {-87.6, 14}, {-87.6, 14}}, color = {0, 0, 127}));
  connect(bus1.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-68, 22}, {-63, 22}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus4.p) annotation(
    Line(points = {{-49, 22}, {-46, 22}}, color = {0, 0, 255}));
  connect(breaker1.s, bus4.p) annotation(
    Line(points = {{-28.5, 28}, {-46, 28}, {-46, 22}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.p, bus2.p) annotation(
    Line(points = {{0, -62}, {0, -62}, {0, -66}, {0, -66}}, color = {0, 0, 255}));
  connect(bus5.p, twoWindingTransformer2.n) annotation(
    Line(points = {{0, -42}, {0, -42}, {0, -50}, {0, -50}, {0, -50}}, color = {0, 0, 255}));
  connect(generator2.p, bus2.p) annotation(
    Line(points = {{0, -74}, {0, -66}}, color = {0, 0, 255}));
  connect(generator2.vf0, generator2.vf) annotation(
    Line(points = {{-8.8, -88.4}, {-14.5, -88.4}, {-14.5, -97}, {-3.8, -97}, {-3.8, -92.4}}, color = {0, 0, 127}));
  connect(generator2.pm0, generator2.pm) annotation(
    Line(points = {{8.8, -88.4}, {12.5, -88.4}, {12.5, -95}, {3.8, -95}, {3.8, -92.4}}, color = {0, 0, 127}));
  connect(pwLine1.p, breaker1.r) annotation(
    Line(points = {{-5, 28}, {-23.5, 28}}, color = {0, 0, 255}));
  Yl4 = S4 / bus4.V_0 ^ 2;
  Yl5 = S5 / bus5.V_0 ^ 2;
  Y11 = 1 / (Complex(0, generator1.x1d) + Complex(0, twoWindingTransformer1.x));
  Y34 = -1 / (Complex(pwLine1.R, 0) + Complex(0, pwLine1.X));
  Y44 = Y11 + Complex(0, pwLine1.B / 2) + Complex(0, pwLine2.B / 2) - Y34 + 1 / Complex(pwLine2.R, pwLine2.X) + Yl4;
  Pe1 = 0;
  Pe2 = E2_abs ^ 2 * 0.1362 + E2_abs * 1 * 5.1665 * cos(16.19 * D2R - 90.755 * D2R);
  D1 = 180 * SysData.fn / (generator1.M / 2) * (bus1.P_0 / SysData.S_b);
  D2 = 180 * SysData.fn / (generator2.M / 2) * (bus2.P_0 / SysData.S_b - Pe2);
//"The  answer may slightly vary due to  rounding off values"
  annotation(
    Documentation(info = "<html><head></head><body>A 5 bus system with fault.</body></html>"));

end Ex14_9;
