model Ex2_4
 OpenIPSL.Types.VoltageKilo Vbus "magnitude of  voltage at substation bus";
  Complex Van "voltage across load";
  Modelica.SIunits.Voltage Vln "line to neutral voltage";
  Real Van_abs (final unit="per unit")"magnitude of Van";
  Modelica.SIunits.Angle Van_arg "argument of Van";
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance1(Z_ref(re = 0.36, im = 1.35)) annotation(
    Placement(visible = true, transformation(origin = {-32, 22}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance2(Z_ref(re = 17.32, im = 10)) annotation(
    Placement(visible = true, transformation(origin = {20, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource1(V = 2670, f = 50, phi = 0.0471239) annotation(
    Placement(visible = true, transformation(origin = {-80, -6}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource2(V = 4400/sqrt(3), f = 50, phi = 0) annotation(
    Placement(visible = true, transformation(origin = {74, -8}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Modelica.SIunits.ComplexImpedance Z_b = Complex(20,0) "base impeadnce";
  parameter Complex Ian= Complex(1*cos(-30*D2R), 1*sin(-30*D2R)) "per unit current across load";
  parameter Complex V= Complex(1*cos(0), 1*sin(0))"per unit voltage";
  parameter Complex Z11 = impedance1.Z_ref / Z_b "per unit line impedance";
  
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {-80, -60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground2 annotation(
    Placement(visible = true, transformation(origin = {20, -58}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground3 annotation(
    Placement(visible = true, transformation(origin = {74, -58}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  
  Van= V+(Ian*Z11);
  Van_abs= sqrt(Van.re^2+Van.im^2);
  Van_arg= atan(Van.im/Van.re);
  Vln= Van_abs*(4400/sqrt(3));
  Vbus = sqrt(3) * (Vln * 1e-3);

  connect(impedance1.pin_n, impedance2.pin_p) annotation(
    Line(points = {{-22, 22}, {20, 22}, {20, 0}}, color = {85, 170, 255}));
  connect(impedance2.pin_n, ground2.pin) annotation(
    Line(points = {{20, -20}, {20, -48}}, color = {85, 170, 255}));
  connect(voltageSource2.pin_p, impedance2.pin_p) annotation(
    Line(points = {{74, 2}, {74, 22}, {20, 22}, {20, 0}}, color = {85, 170, 255}));
  connect(voltageSource2.pin_n, ground3.pin) annotation(
    Line(points = {{74, -18}, {74, -48}}, color = {85, 170, 255}));
  connect(voltageSource1.pin_n, ground1.pin) annotation(
    Line(points = {{-80, -16}, {-80, -16}, {-80, -50}, {-80, -50}}, color = {85, 170, 255}));
  connect(voltageSource1.pin_p, impedance1.pin_p) annotation(
    Line(points = {{-80, 4}, {-80, 22}, {-42, 22}}, color = {85, 170, 255}));
 
//"The  answer may slightly vary due to  rounding off values"
end Ex2_4;
