model Ex4_4

  Real r (final unit="ft") "radius of the conductor";
  Real Dpsc (final unit="ft") "Geometric mean of the GMR values of the conductors";
  Real Cn (final unit="F/m") "capacitance to neutral";
  Real Bc (final unit="mho/mi per phase to neutral") "capacitive susceptance";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  parameter Real l (final unit="ft")= 21 "length of the conductor";
  parameter Real Deq (final unit="ft")= 16.1 "Geometric mean of the distances between the conductors";
  parameter Real Ds (final unit="ft")= 0.680 "outer diametr of ACSR Ostrich conductor";
  parameter Modelica.SIunits.Frequency f= 60 "frequency";
  
equation
   r= (Ds)/(2*12);
   Dpsc= (26.9*r*l*r*26.9*r)^(1/6);
   Cn= (2*pi*8.85e-12)/(log(Deq/Dpsc));
   Bc= (2*pi*f*Cn*1609);
   
//"The  answer may slightly vary due to  rounding off values" 
 
end Ex4_4;
