model Ex6_1

  Modelica.SIunits.ComplexVoltage V2 "secondary side voltage";
  Modelica.SIunits.Voltage abs_V2 "magnitude of V2";
  Modelica.SIunits.Angle arg_V2 "argument of V2";
  Modelica.SIunits.ComplexCurrent I2 "secondary side current";
  Modelica.SIunits.Current abs_I2 "magnitude of I2";
  Modelica.SIunits.Angle arg_I2 "argument of I2";
  Modelica.SIunits.ComplexImpedance Z2 "impedance across V2";                                                                                                                                                                           
  Modelica.SIunits.Impedance abs_Z2 "magnitude of Z2";
  Modelica.SIunits.Angle arg_Z2 "argument of Z2";
  Modelica.SIunits.ComplexImpedance Z2_1 "value of Z2 refered to primary side of the transformer  ";
  Modelica.SIunits.Impedance abs_Z2_1 "magnitude of Z2_1";
  Modelica.SIunits.Angle arg_Z2_1 "argument of Z2_1";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Real N1= 2000 "no. of turns at primary";
  parameter Real N2= 500 "no. of turns at secondary";
  parameter Real a= N1/N2 "turns ratio";
  parameter Real b= N2/N1 "turns ratio";
  parameter Modelica.SIunits.Voltage abs_V1= 1200 "voltage at primary";
  parameter Modelica.SIunits.Angle arg_V1= 0 ;
  parameter Modelica.SIunits.ComplexVoltage V1= Complex(abs_V1*cos((arg_V1)), abs_V1*sin((arg_V1))) "voltage at primary";
  parameter Modelica.SIunits.Current abs_I1= 5 "current at primry";
  parameter Modelica.SIunits.Angle arg_I1= -pi/6 ;
  parameter Modelica.SIunits.ComplexCurrent I1= Complex(abs_I1*cos((arg_I1)), abs_I1*sin((arg_I1))) "current at primry";
  
equation
  V2= b*(V1);
  abs_V2= (((V2.re)^(2))+((V2.im)^(2)))^(0.5);
  arg_V2= (atan(V2.im/V2.re));
  I2= a*I1;
  abs_I2= (((I2.re)^(2))+((I2.im)^(2)))^(0.5);
  arg_I2= (atan(I2.im/I2.re));
  Z2= V2/I2;
  abs_Z2= (((Z2.re)^(2))+((Z2.im)^(2)))^(0.5);
  arg_Z2= (atan(Z2.im/Z2.re));
  Z2_1= Z2*(a^2);
  abs_Z2_1= (((Z2_1.re)^(2))+((Z2_1.im)^(2)))^(0.5);
  arg_Z2_1= (atan(Z2_1.im/Z2_1.re));
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex6_1;
