model Ex6_11
OpenIPSL.Types.ActivePowerMega Sm "Total powers of two motors in Ex6_10 in MW";
  Real Sm_pu (final unit= "per unit") "Sm in per unit";
  Real V (final unit= "per unit") "per unit voltage";
  Real I (final unit= "per unit") "per unit current";
  Complex Vgen "per unit generator voltage";
  Real Vgen_abs (final unit= "per unit") "magnitude of Vgen";
  Modelica.SIunits.Angle Vgen_arg "angle of Vgen";
  OpenIPSL.Types.VoltageKilo Vgen_terminal "generator terminal Voltage in KV";
  
  parameter OpenIPSL.Types.ActivePowerMega Sm1 = 60 "rating of motor1 in MW";
  parameter OpenIPSL.Types.ActivePowerMega Sm2 = 120 "rating of motor2 in MW";
  parameter OpenIPSL.Types.VoltageKilo Vmotor = 13.2 "Voltage rating of both motors in KV";
  parameter OpenIPSL.Types.ApparentPowerMega Sb = 300 "Base power in MVA";
  parameter OpenIPSL.Types.VoltageKilo Vb = 20 "base voltage in KV";
  parameter OpenIPSL.Types.VoltageKilo Vmc = 13.8 "motor voltage w.r.t Base in KV";
  parameter Complex Xtr1 = Complex(0, 0.0857) "per unit reactance of transformer 1 obtained from Ex6_10";
  parameter Complex Xtr2 = Complex(0, 0.0915) "per unit reactance of transformer 2 obtained from Ex6_10";
  parameter Complex Xtl = Complex(0, 0.1815) "per unit reactance of transmission line obtained from Ex6_10";
 
equation
  Sm = Sm1 + Sm2;
  Sm_pu = Sm / Sb;
  V = Vmotor / Vmc;
  I = Sm_pu / V;
  Vgen = V + I * (Xtr1 + Xtr2 + Xtl);
  Vgen_abs = sqrt(Vgen.re ^ 2 + Vgen.im ^ 2);
  Vgen_arg = atan(Vgen.im / Vgen.re);
  Vgen_terminal = Vgen_abs * Vb;
  
//"The  answer may slightly vary due to  rounding off values" 

end Ex6_11;
