model Ex6_4

  Modelica.SIunits.Impedance Zb_LT "base impedance on low tension side";
  Real Zb_LT_pu (final unit= "per unit") "base impedance on low tension side on per unit"; 
  Modelica.SIunits.Reactance X_leakage_HT "leakage reactance on high tension side";
  Modelica.SIunits.Impedance Zb_HT "base impedance on high tension side";
  Real Zb_HT_pu (final unit= "per unit") "base impedance on high tension side on per unit";
  
  parameter Modelica.SIunits.Voltage Vp= 110 "primary side voltage";
  parameter Modelica.SIunits.Voltage Vs= 440 "secondary side voltage";
  parameter Real a= Vs/Vp "turns ratio";
  parameter Real Pb (final unit= "KVA")= 2.5 "power rating of transformer";
  parameter Modelica.SIunits.Reactance X_leakage= 0.06 "leakage reactance";
  
equation
  Zb_LT= (((Vp*1e-3)^2)*1000)/Pb;
  Zb_LT_pu=  X_leakage/Zb_LT;
  X_leakage_HT= X_leakage*(a^2);
  Zb_HT= (((Vs*1e-3)^2)*1000)/Pb;
  Zb_HT_pu= X_leakage_HT/Zb_HT;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex6_4;
