model Ex6_6

  Modelica.SIunits.Impedance Zb_Lt "Base Impedance on L-T side";
  Real Rl (final unit= "per unit") "Load Resistance";
  Modelica.SIunits.Impedance Zb_Ht "Base Impedance on H-T side";
  
  parameter OpenIPSL.Types.ApparentPowerMega Sn= 25 "Power rating of transformer";
  parameter OpenIPSL.Types.VoltageKilo Vp= 38.1 "Primary voltage";
  parameter OpenIPSL.Types.VoltageKilo Vs= 3.81 "Secondary voltage";
  parameter Modelica.SIunits.Resistance rl= 0.6 "Balanced load";
  parameter OpenIPSL.Types.VoltageKilo Vb= 66 "Base voltage";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= 75 "Base power"; 
  
equation
  Zb_Lt= (Vs^2)/Sb;
  Rl= rl/Zb_Lt;
  Zb_Ht= (Vb^2)/Sb;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex6_6;
