model Ex6_7

  Real Zb (final unit= "per unit") "Transformer reactance on its own base";
  Real Zb1 (final unit= "per unit") "Transformer reactance on the chosen base";
  
  parameter OpenIPSL.Types.ApparentPowerMega Sn= 400 "Power rating of transformer";
  parameter OpenIPSL.Types.VoltageKilo Vp= 220 "Primary voltage";
  parameter OpenIPSL.Types.VoltageKilo Vs= 22 "Secondary voltage";
  parameter Modelica.SIunits.Resistance rl= 0.121 "Short circuit impedance measured on L-T side ";
  parameter OpenIPSL.Types.VoltageKilo Vb= 230 "Base voltage";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= 100 "Base power"; 
  
equation  
  Zb= rl/((Vs^2)/Sn);
  Zb1= Zb*(((Vp/Vb)^2)*(Sb/Sn)); 
 
//"The  answer may slightly vary due to  rounding off values" 
end Ex6_7;
