model Ex7_2

// refer Ex7_1 also
  Complex [4,4]Ybus "admittance matrix obtained from Ex_7_1";
  Complex [4,4]Zbus "bus impedance matrix";
  Complex V1 "voltage at node 1";
  Complex V2 "voltage at node 2";
  Complex V3 "voltage at node 3";
  Complex V4 "voltage at node 4";
  Real V1_abs (final unit= "per unit") "magnitude of V1";
  Modelica.SIunits.Angle V1_arg "argument of V1";
  Real V2_abs (final unit= "per unit") "magnitude of V2";
  Modelica.SIunits.Angle V2_arg "argument of V2";
  Real V3_abs (final unit= "per unit") "magnitude of V3";
  Modelica.SIunits.Angle V3_arg "argument of V3";
  Real V4_abs (final unit= "per unit") "magnitude of V4";
  Modelica.SIunits.Angle V4_arg "argument of V4";
   parameter Complex Y11= Complex(0, -5.0-4.0-0.8) "self admittance of bus 1";
   parameter Complex Y22 = Complex(0, -5.0-2.5-0.8) "self admittance of bus 2";
   parameter Complex Y33 = Complex(0, -4.0-2.5-8.0-0.8) "self admittance of bus 3";
   parameter Complex Y44 = Complex(0, -5.0-5.0-8.0) "self admittance of bus 4";
   parameter Complex Y12 = Complex(0, 0) "mutual admittance between bus 1 and 2";
   parameter Complex Y21 = Y12 "mutual admittance between bus 2 and 1";
   parameter Complex Y23 = Complex(0, 2.5) "mutual admittance between bus 2 and 3";
   parameter Complex Y32 = Y23 "mutual admittance between bus 3 and 2";
   parameter Complex Y13 = Complex(0, 4.0) "mutual admittance between bus 1 and 3";
   parameter Complex Y31 = Y13 "mutual admittance between bus 3 and 1";
   parameter Complex Y14 = Complex(0, 5) "mutual admittance between bus 1 and 4";
   parameter Complex Y41 = Y14 "mutual admittance between bus 4 and 1";
   parameter Complex Y34 = Complex(0, 8) "mutual admittance between bus 3 and 4";
   parameter Complex Y43 = Y34 "mutual admittance between bus 4 and 3";
   parameter Complex Y24 = Complex(0, 5) "mutual admittance between bus 2 and 4";
   parameter Complex Y42 = Y24 "mutual admittance between bus 4 and 2";
   parameter Complex [4,1]Ibus = {{Complex(0, -1.20)}, {Complex(-0.72, -0.96)}, {Complex(0, -1.20)}, {Complex(0, 0)}} "total current";
equation
  Ybus = {{Y11, Y12, Y13, Y14}, {Y21, Y22, Y23, Y24}, {Y31, Y32, Y33, Y34}, {Y41, Y42, Y43, Y44}};
  Zbus = Complex(0, -Modelica.Math.Matrices.inv(Ybus.im));
  V1= (-Zbus[1,1]*Ibus[1,1])+(-Zbus[1,2]*Ibus[2,1])+(-Zbus[1,3]*Ibus[3,1])+(-Zbus[1,4]*Ibus[4,1]);
  V2= (-Zbus[2,1]*Ibus[1,1])+(-Zbus[2,2]*Ibus[2,1])+(-Zbus[2,3]*Ibus[3,1])+(-Zbus[2,4]*Ibus[4,1]);
  V3= (-Zbus[3,1]*Ibus[1,1])+(-Zbus[3,2]*Ibus[2,1])+(-Zbus[3,3]*Ibus[3,1])+(-Zbus[3,4]*Ibus[4,1]);
  V4= (-Zbus[4,1]*Ibus[1,1])+(-Zbus[4,2]*Ibus[2,1])+(-Zbus[4,3]*Ibus[3,1])+(-Zbus[4,4]*Ibus[4,1]);
  V1_abs= sqrt((V1.re^2)+(V1.im^2));
  V1_arg= atan(V1.im/V1.re);
  V2_abs= sqrt((V2.re^2)+(V2.im^2));
  V2_arg= atan(V2.im/V2.re);
  V3_abs= sqrt((V3.re^2)+(V3.im^2));
  V3_arg= atan(V3.im/V3.re);
  V4_abs= sqrt((V4.re^2)+(V4.im^2));
  V4_arg= atan(V4.im/V4.re);
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex7_2;
