model Ex8_2

  Complex S "total power of generator- P+jQ";
  Real P (final unit= "per unit") "active power obtained from S";
  Real Q (final unit= "per unit") "reactive power obtained from S";
  Complex Eg "Generator emf";
  Real Eg_abs (final unit= "per unit") "magnitude of Eg";
  Modelica.SIunits.Angle Eg_arg "argument of Eg";
  Complex Eth "Thevenin eqyivalent voltage";
  Real Eth_abs (final unit= "per unit") "magnitude of Eth";
  Modelica.SIunits.Angle Eth_arg "argument of Eth";
  Modelica.SIunits.Angle del "load angle";
  Complex Vt1 "voltage at generator terminal";
  Real Vt1_abs (final unit= "per unit") "magnitude of Vt1";
  Modelica.SIunits.Angle Vt1_arg "argument of Vt1";
  Complex Ig "current delivered by the generator when generator is delivering the same power P to the system";
  Real Ig_abs (final unit= "per unit") "argument of Ig";
  Modelica.SIunits.Angle Ig_arg "argument of Ig";
  Complex Egen "Generator emf";
  Real Egen_abs (final unit= "per unit") "argument of Egen";
  Modelica.SIunits.Angle Egen_arg "argument of Egen";
  Complex Sgen "total power in generator terminal for 2nd case";
  Real Sgen_abs (final unit= "per unit") "argument of Sgen";
  Modelica.SIunits.Angle Sgen_arg "argument of Sgen";
  
  parameter Real pi = 22 / 7;
  parameter Real R2D = 180 / pi;
  parameter Real D2R = pi/180;
  parameter OpenIPSL.Types.ActivePowerMega P1= 0.8 "Active power in generator";
  parameter OpenIPSL.Types.ReactivePowerMega Q1= 0.2 "Reactive power in generator";
  parameter Real Vt (final unit= "per unit")= 0.97 "voltage at generator terminal";
  parameter Complex I= Complex(0.8, -0.2) "current delivered by the generator";
  parameter Complex Zth= Complex(0, 0.2) "Thevenin equvalent impedance(pu)";
  parameter Complex Xd= Complex(0, 1) "Synchronolus reactance of generator(pu)";
  parameter Real Vt_mod (final unit= "per unit")= 1.0 "voltage at generator terminal when generator is delivering the same power P to the system";
  
equation
  S= Complex(Vt*P1,Vt*Q1);
  P= S.re;
  Q= S.im;
  Eg= Vt+Xd*I;
  Eg_abs = sqrt(Eg.re ^ 2 + Eg.im ^ 2);
  Eg_arg = atan(Eg.im / Eg.re);
  //when generator is delivering the same power P to the system
  Eth= Vt-Zth*I;
  Eth_abs = sqrt(Eth.re ^ 2 + Eth.im ^ 2);
  Eth_arg = atan(Eth.im / Eth.re); 
  del= asin((P*Zth.im)/(Vt_mod*Eth_abs));
  Vt1= Complex(Vt_mod*cos((Eth_arg+del)),Vt_mod*sin((Eth_arg+del)));
  Vt1_abs = sqrt(Vt1.re ^ 2 + Vt1.im ^ 2);
  Vt1_arg = atan(Vt1.im / Vt1.re);
  Ig= (Vt1-Eth)/Zth;
  Ig_abs = sqrt(Ig.re ^ 2 + Ig.im ^ 2);
  Ig_arg = atan(Ig.im / Ig.re);
  Egen= Vt1+Xd*Ig;
  Egen_abs = sqrt(Egen.re ^ 2 + Egen.im ^ 2);
  Egen_arg = atan(Egen.im / Egen.re); 
  Sgen= Vt1*(Complex(Ig.re,-Ig.im));
  Sgen_abs = sqrt(Sgen.re ^ 2 + Sgen.im ^ 2);
  Sgen_arg = atan(Sgen.im / Sgen.re);
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex8_2;
