model Ex1_1
  parameter Real load(final quantity = "Power", final unit = "kW") = 760 "fixed load";
  parameter Real pf = 0.8 "load factor";
  parameter Real loss_in_switchgear = 0.05 "switchgear losses at full amount to 5%";
  parameter Real HV_switchgear_cost(unit = "Rs/kVA") = 60 "HV switchgear cost";
  parameter Real charge_switchgear = 0.12 "Interest, depreciation charges for switchgear are 12% of capital cost";
  parameter Real cost_1(unit = "INR/kVA") = 32 "LV supply price";
  parameter Real cost_2(unit = "INR/kVA") = 30 "HV supply price";
  parameter Real h(unit = "hour/week") = 48 "working hours";
  parameter Real w = 52 "total week in a year";
  parameter Real p(unit ="paise/kWh") = 0.10 "paise";
  parameter Real max_demand(final quantity = "Power", final unit = "kVA") = load / pf "maximum demand";
  parameter Real fl_amt = 1 - loss_in_switchgear "without loss amount";
  parameter Real input_demand(final quantity = "Power", final unit = "kVA") = max_demand / fl_amt "input demand";
  parameter Real cost_of_switchgear(unit = "Rs") = input_demand * HV_switchgear_cost "cost of switchgear";
  parameter Real annual_charge1(unit = "Rs") = cost_of_switchgear * charge_switchgear "annual charges on depreciation";
  //case b
  parameter Real charge1(unit = "Rs") = cost_2 * input_demand "aannual fixed charges due to max demand corresponding to tariff";
  parameter Real charge_b(unit = "Rs") = input_demand * pf * h * w * p "annual running charges due to kWh consumed";
  parameter Real charge_total1(unit = "Rs") = annual_charge1 + charge1 + charge_b "total charges /annum";
  //case a
  parameter Real demand_max(final quantity = "Power", final unit = "kVA") = max_demand "maximum demand corresponding to tariff";
  parameter Real annual_charge2(unit = "Rs") = cost_1 * demand_max "annual fixed charges";
  parameter Real charge_a(unit = "Rs") = demand_max * pf * h * w * p "annual running charges due to kWh consumed";
  parameter Real charge_total2(unit = "Rs") = annual_charge2 + charge_a "total charge";

end Ex1_1;
