model Ex1_5
  //consumer1
  parameter Real MD_1(final quantity = "Power", final unit = "kW") = 5 "maximum demand at 6pm";
  parameter Real D_1(final quantity = "Power", final unit = "kW") = 3 "demand at 7pm";
  parameter Real lf_1 = 0.2 "daily load factor";
  //consumer2
  parameter Real MD_2(final quantity = "Power", final unit = "kW") = 5 "maximum demand at 11pm";
  parameter Real D_2(final quantity = "Power", final unit = "kW") = 2 "demand at 7pm ";
  parameter Real avg_l2(final quantity = "Power", final unit = "kW") = 1.2 "avg load";
  //consumer3
  parameter Real MD_3(final quantity = "Power", final unit = "kW") = 3 "maximum demand at 7pm";
  parameter Real avg_l3(final quantity = "Power", final unit = "kW") = 1 "avg load";
  //solution a
  parameter Real MD(final quantity = "Power", final unit = "kW") = D_1 + D_2 + MD_3 "max demand of the system at 7pm";
  parameter Real S_MD(final quantity = "Power", final unit = "kW") = MD_1 + MD_2 + MD_3 "sum of max demands";
  parameter Real df = S_MD / MD "diversity factor";
  // solution b
  parameter Real avg_load(final quantity = "Power", final unit = "kW") = lf_1 * MD_1 "average load of consumer1";
  parameter Real LF2(unit = "%") = avg_l2 / MD_2 * 100 "load factor of consumer2";
  parameter Real LF3(unit = "%") = avg_l3 / MD_3 * 100 "load factor of consumer3";
  //solution c
  parameter Real C_avg_l(final quantity = "Power", final unit = "kW") = avg_load + avg_l2 + avg_l3 "combined avg load";
  parameter Real C_lf(unit = "%") = C_avg_l / 8 * 100 "combined load factor";

end Ex1_5;
