model Ex1_6
  parameter Real efficiency(unit = "%") = 0.9 "efficiency of hydraulic turbine and electric generator together";
  parameter Modelica.SIunits.Density density = 1000 "density of flow";
  parameter Modelica.SIunits.VolumeFlowRate W = 575 "average flow during the period of interest ";
  parameter Modelica.SIunits.Height H = 100 "head";
  parameter Real P(final quantity = "Power", final unit = "MW") = 9.81 * efficiency * density * W * H * 1e-6 "power of the whole system";
  //The answers may slightly vary due to rounding off values.
end Ex1_6;
