model Ex12_1
OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = H, Sn = Sn1, V_b = 11, Vn = 11, ra = 0.001, x1d = 0.15) annotation(
    Placement(visible = true, transformation(origin = {7.10543e-15, -4}, extent = {{-26, -26}, {26, 26}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {62, 68}, extent = {{-34, -26}, {34, 26}}, rotation = 0)));
  parameter Real Sn1(final quantity="Power", final unit="MVA") = 100 "base power of turbogenerator";
  parameter Real V(final quantity="Potential", final unit="kV") = 11 "base voltage of turbogenerator";
  parameter Real H(final quantity="Inertia", final unit="MJ/MVA") = 8 "inertia constant of turbogenerator";
  parameter Real E(final quantity="Energy", final unit="MJ") = Sn1 * H "stored energy in rotor";
  parameter Real P(final quantity="Power", final unit="MW") = 30 "Increase in load";
  parameter Modelica.SIunits.Frequency f = 50 "frequency of four pole turbogenerator";
  parameter Real M(unit="MJ-s/elect deg") = E / (180 * f) "inertia constant";
  parameter Real A(final quantity="Acceleration", final unit="elect deg/s2") = P / M "rotor acceleration";
  parameter Real T(unit="elect deg") = 0.5 * A * 0.2 * 0.2 "change in torque angle";
  parameter Real S(unit="rpm") = 1500 + A / 12 * 0.2 "Rotor speed at the end of 10 cycles";
equation
  connect(order21.vf, order21.vf0) annotation(
    Line(points = {{-32, 10}, {-48, 10}, {-48, 40}, {-20, 40}, {-20, 24}, {-20, 24}}, color = {0, 0, 127}));
  connect(order21.pm, order21.pm0) annotation(
    Line(points = {{-32, -16}, {-48, -16}, {-48, -42}, {-20, -42}, {-20, -32}, {-20, -32}}, color = {0, 0, 127}));
//The answers may slightly vary due to rounding off values.
end Ex12_1;
