model Ex12_10
OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = x2) annotation(
    Placement(visible = true, transformation(origin = {-22, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = x3) annotation(
    Placement(visible = true, transformation(origin = {-58, -20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = x4) annotation(
    Placement(visible = true, transformation(origin = {10, -20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-94, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {86, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1) annotation(
    Placement(visible = true, transformation(origin = {150, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 20, fn = freq) annotation(
    Placement(visible = true, transformation(origin = {-160, 76}, extent = {{-20, -18}, {20, 18}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 1.2, t1 = 0.5, t2 = 1) annotation(
    Placement(visible = true, transformation(origin = {-48, -48}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, Sn = 20, V_0 = 1.1, V_b = 400, Vn = 440, ra = 0.001, x1d = x1) annotation(
    Placement(visible = true, transformation(origin = {-150, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  
  parameter Modelica.SIunits.Frequency freq = 50 "base frequency";
  parameter Real S_n(final quantity="Power", final unit="MVA")=20"base power";
  parameter Real P_delivered(final quantity="Power", final unit="MW")=18"power delivered by generator to infinite bus";
  parameter Real modE(unit = "pu") = 1.1"voltage of generator";
  parameter Real V(unit = "pu") = 1"voltage of infinite bus";
  parameter Real x1(unit = "pu") = 0.35 "generator reactance";
  parameter Real x2(unit = "pu") = 0.2"reactance of transmission line1";
  parameter Real x3(unit = "pu") = 0.1"reactance of transmission line2";
  parameter Real x4(unit = "pu") = 0.1"reactance of transmission line3";
  parameter Real H(unit = "MJ/MVA") = 2.52 "kinetic energy of generator";
  parameter Real M(unit = "s^2/elect degree") = H / (180 * freq) "inertia constant";
  constant Real pi = 2 * Modelica.Math.asin(1.0);    // 3.14159265358979 in radian;
  //prefault condition
  parameter Real Pe1(unit = "pu") = 0.9 "prefault power transfer";
  parameter Real X11(unit = "pu") = x1 + x2 / 2 "total reactance during pre fault";
  parameter Real Pmax1(unit = "pu") = modE / X11 "maximum power";
  parameter Real delta(unit = "degree") = 180 / pi * asin(Pe1 / Pmax1)"initial power angle";
  //during fault
  parameter Real X12(unit = "pu") = ((x1 * x3) + (x2 * x4) + (x1 * x2)) / x3 "total reactance during fault";
  parameter Real Pmax2(unit = "pu") = modE / X12 "maximum power during fault";
  //post fault
  parameter Real X13(unit = "pu") = x1 + x2 "total reactance during post fault";
  parameter Real Pmax3(unit = "pu") = modE / X13 "max power during post fault";
  parameter Real Pavg01(unit = "pu") = 0"accelerating power immediately before fault";
  parameter Real Pavg02(unit = "pu") = 0.9 - Pmax2 * sin(delta)"accelerating power immediately after fault";
  parameter Real Pavg(unit = "pu") = (Pavg01 + Pavg02) / 2 "avg value of accelerating power";
  //case-a
  //The procedure of calculations is described below by calculating the row corresponding to t=0.15s of table 12.2 that describes 'point-by-point computations of swing curve for sustained fault'
  parameter Real delta_old_a(unit = "degree")=31.59"value of torque angle at 0.1s";
  parameter Real Pmax_old_a(unit = "pu")=0.88"value of mechanical power input at 0.1s";
  parameter Real sin_delta_old_a=0.524"value of sin(delta) at 0.1s";
  parameter Real del_delta_old_a(unit = "degree")=7.38"increment of torque angle at 0.1s";
  parameter Real Pe_old_a(unit = "pu")=Pmax_old_a*sin_delta_old_a"electrical power output at 0.1s";
  parameter Real Pa_old_a(unit = "pu")=Pe1-Pe_old_a"accelerating power at 0.1s";
  parameter Modelica.SIunits.Time del_t=0.05"time period";
  parameter Real Pa_1_old_a(unit = "degree")=((del_t^2)/M)*Pa_old_a"accelerating power after multiplying with constant at 0.1s";
  parameter Real del_delta_new_a(unit = "degree")=del_delta_old_a+Pa_1_old_a"increment of torque angle at 0.15s";
  parameter Real delta_new_a(unit = "degree")=delta_old_a+del_delta_new_a"value of torque angle at 0.15s";
  parameter Modelica.SIunits.Time t1=0.05"fault clearing time at case b";
  parameter Modelica.SIunits.Time t2=0.125"fault clearing time at case c";
  //case-b
  //The procedure of calculations is described below by calculating the row corresponding to t=0.15s of table 12.3 that describes 'computation of swing curve for fault cleared at  t1'
  parameter Real delta_old_b(unit = "degree")=29.54"value of torque angle at 0.1s";
  parameter Real Pmax_old_b(unit = "pu")=2"value of mechanical power input at 0.1s";
  parameter Real sin_delta_old_b=0.493"value of sin(delta) at 0.1s";
  parameter Real del_delta_old_b(unit = "degree")=5.33"increment of torque angle at 0.1s";
  parameter Real Pe_old_b(unit = "pu")=Pmax_old_b*sin_delta_old_b"electrical power output at 0.1s";
  parameter Real Pa_old_b(unit = "pu")=Pe1-Pe_old_b"accelerating power at 0.1s";
  parameter Modelica.SIunits.Time del_t_b=0.05"time period";
  parameter Real Pa_1_old_b(unit = "degree")=((del_t_b^2)/M)*Pa_old_b"accelerating power after multiplying with constant at 0.1s";
  parameter Real del_delta_new_b(unit = "degree")=del_delta_old_b+Pa_1_old_b"increment of torque angle at 0.15s";
  parameter Real delta_new_b(unit = "degree")=delta_old_b+del_delta_new_b"value of torque angle at 0.15s";
  //case-c
  //The procedure of calculations is described below by calculating the row corresponding to t=0.15s of table 12.4 that describes 'computation of swing curve for fault cleared at  t2'
  parameter Real delta_old_c(unit = "degree")=31.59"value of torque angle at 0.1s";
  parameter Real Pmax_old_c(unit = "pu")=0.88"value of mechanical power input at 0.1s";
  parameter Real sin_delta_old_c=0.524"value of sin(delta) at 0.1s";
  parameter Real del_delta_old_c(unit = "degree")=7.38"increment of torque angle at 0.1s";
  parameter Real Pe_old_c(unit = "pu")=Pmax_old_c*sin_delta_old_c"electrical power output at 0.1s";
  parameter Real Pa_old_c(unit = "pu")=Pe1-Pe_old_c"accelerating power at 0.1s";
  parameter Modelica.SIunits.Time del_t_c=0.05"time period";
  parameter Real Pa_1_old_c(unit = "degree")=((del_t_c^2)/M)*Pa_old_c"accelerating power after multiplying with constant at 0.1s";
  parameter Real del_delta_new_c(unit = "degree")=del_delta_old_c+Pa_1_old_c"increment of torque angle at 0.15s";
  parameter Real delta_new_c(unit = "degree")=delta_old_c+del_delta_new_c"value of torque angle at 0.15s";
  
  //The answers may slightly vary due to rounding off values.
equation
  connect(pwLine2.n, pwFault1.p) annotation(
    Line(points = {{-48, -20}, {-48, -41}}, color = {0, 0, 255}));
  connect(order21.vf0, order21.vf) annotation(
    Line(points = {{-158, 12}, {-158, 12}, {-158, 16}, {-168, 16}, {-168, 6}, {-162, 6}, {-162, 6}}, color = {0, 0, 127}));
  connect(order21.pm0, order21.pm) annotation(
    Line(points = {{-158, -10}, {-158, -10}, {-158, -16}, {-168, -16}, {-168, -6}, {-162, -6}, {-162, -4}}, color = {0, 0, 127}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-94, 0}, {-76, 0}, {-76, 20}, {-31, 20}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{-13, 20}, {28, 20}, {28, 0}, {86, 0}}, color = {0, 0, 255}));
  connect(pwLine2.n, pwLine3.p) annotation(
    Line(points = {{-49, -20}, {1, -20}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus2.p) annotation(
    Line(points = {{19, -20}, {28, -20}, {28, 0}, {86, 0}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine2.p) annotation(
    Line(points = {{-94, 0}, {-76, 0}, {-76, -20}, {-66, -20}, {-66, -20}}, color = {0, 0, 255}));
  connect(bus2.p, infiniteBus1.p) annotation(
    Line(points = {{86, 0}, {160, 0}}, color = {0, 0, 255}));
  connect(order21.p, bus1.p) annotation(
    Line(points = {{-140, 0}, {-94, 0}}, color = {0, 0, 255}));

annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex12_10;
