model Ex12_11
OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = x2) annotation(
    Placement(visible = true, transformation(origin = {-22, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = x3) annotation(
    Placement(visible = true, transformation(origin = {-58, -20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = x4) annotation(
    Placement(visible = true, transformation(origin = {10, -20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-94, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {86, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1) annotation(
    Placement(visible = true, transformation(origin = {150, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 20, fn = freq) annotation(
    Placement(visible = true, transformation(origin = {-160, 76}, extent = {{-20, -18}, {20, 18}}, rotation = 0)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 1.2, t1 = 0.5, t2 = 1) annotation(
    Placement(visible = true, transformation(origin = {-42, -48}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 8, Sn = 20, V_0 = 1.1, V_b = 400, Vn = 440, ra = 0.001, x1d = x1) annotation(
    Placement(visible = true, transformation(origin = {-150, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  parameter Modelica.SIunits.Frequency freq = 50 "base frequency";
  parameter Real S_n(final quantity="Power", final unit="MVA")=20"base power";
  parameter Real P_delivered(final quantity="Power", final unit="MW")=18"power deivered by generator to infinite bus";
  parameter Real modE(unit = "pu") = 1.1"voltage of generator";
  parameter Real V(unit = "pu") = 1"voltage of infinite bus";
  parameter Real x1(unit = "pu") = 0.35 "generator reactance";
  parameter Real x2(unit = "pu") = 0.2"reactance of transmission line1";
  parameter Real x3(unit = "pu") = 0.1"reactance of transmission line2";
  parameter Real x4(unit = "pu") = 0.1"reactance of transmission line3";
  parameter Real H(unit = "MJ/MVA") = 2.52 "kinetic energy of generator";
  parameter Real M(unit = "s^2/elect degree") = H / (180 * freq) "inertia constant";
  constant Real pi = 2 * Modelica.Math.asin(1.0);    // 3.14159265358979 in radian;
  //prefault condition
  parameter Real Pe1(unit = "pu") = 0.9 "prefault power transfer";
  parameter Real X11(unit = "pu") = x1 + x2 / 2 "total reactance during pre fault";
  parameter Real Pmax1(unit = "pu") = modE / X11 "maximum power";
  parameter Real delta(unit = "degree") = 180 / pi * asin(Pe1 / Pmax1)"initial power angle";
  parameter Real delta1(unit = "rad") = pi / 180 * delta"initial power angle";
  
  //during fault
  parameter Real X12(unit = "pu") = ((x1 * x3) + (x2 * x4) + (x1 * x2)) / x3 "total reactance during fault";
  parameter Real Pmax2(unit = "pu") = modE / X12 "maximum power during fault";
  //post fault
  parameter Real X13(unit = "pu") = x1 + x2 "total reactance during post fault";
  parameter Real Pmax3(unit = "pu") = modE / X13 "max power during post fault";
  parameter Modelica.SIunits.Time del_t=0.05"time period";
  parameter Real w_o(unit = "rad/sec")=0"initial angular velocity";
  parameter Real K1=w_o*del_t"Runge_Kutta order-2 method's constant";
  parameter Real h1=62.3*(Pe1-(Pmax2*sin(delta1)))*del_t"Runge_Kutta order-2 method's constant";
  parameter Real h2=h1"Runge_Kutta order-2 method's constant";
  parameter Real K2=h1*del_t"Runge_Kutta order-2 method's constant";
  parameter Real del_delta_0(unit = "rad")=0.5*(K1+K2)"increment on rotor angle";
  parameter Real del_w_o(unit = "rad/sec")=0.5*(h1+h2)"increment in angular velocity";
//The answers may slightly vary due to rounding off values.
equation
  connect(order21.vf0, order21.vf) annotation(
    Line(points = {{-158, 12}, {-158, 12}, {-158, 16}, {-168, 16}, {-168, 6}, {-162, 6}, {-162, 6}}, color = {0, 0, 127}));
  connect(order21.pm0, order21.pm) annotation(
    Line(points = {{-158, -10}, {-158, -10}, {-158, -16}, {-168, -16}, {-168, -6}, {-162, -6}, {-162, -4}}, color = {0, 0, 127}));
  connect(pwLine2.n, pwFault1.p) annotation(
    Line(points = {{-48, -20}, {-42, -20}, {-42, -40}, {-42, -40}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-94, 0}, {-76, 0}, {-76, 20}, {-31, 20}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{-13, 20}, {28, 20}, {28, 0}, {86, 0}}, color = {0, 0, 255}));
  connect(pwLine2.n, pwLine3.p) annotation(
    Line(points = {{-49, -20}, {1, -20}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus2.p) annotation(
    Line(points = {{19, -20}, {28, -20}, {28, 0}, {86, 0}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine2.p) annotation(
    Line(points = {{-94, 0}, {-76, 0}, {-76, -20}, {-66, -20}, {-66, -20}}, color = {0, 0, 255}));
  connect(bus2.p, infiniteBus1.p) annotation(
    Line(points = {{86, 0}, {160, 0}}, color = {0, 0, 255}));
  connect(order21.p, bus1.p) annotation(
    Line(points = {{-140, 0}, {-94, 0}}, color = {0, 0, 255}));

annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");
end Ex12_11;
