model Ex12_5
inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-116, 72}, extent = {{-22, -20}, {22, 20}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 Generator1(D = 0, M = 8, Sn = 100, Vn = 480, ra = 0.001, x1d = X1) annotation(
    Placement(visible = true, transformation(origin = {-116, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0, X = X11) annotation(
    Placement(visible = true, transformation(origin = {0, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1 annotation(
    Placement(visible = true, transformation(origin = {-72, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2 annotation(
    Placement(visible = true, transformation(origin = {68, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1 annotation(
    Placement(visible = true, transformation(origin = {120, 0}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  parameter Modelica.SIunits.Frequency f = 50 "frequency of system";
  parameter Real H(final quantity="Inertia", final unit="MW-s/MVA") = 4 "inertia constant of generator";
  parameter Real V_noload(unit = "pu")=1"generator no load voltage";
  parameter Real V_mod(unit = "pu")=1"infinite bus voltage";
  parameter Real X1(unit = "pu") = 1.2 "generator reactance";
  parameter Real X11(unit = "pu") = 0.6 "pw line reactance";
  parameter Real Xt(unit = "pu") = X1 + X11 "total reactance";
  parameter Real A1(unit = "radian") = asin(0.5) "torque angle for 50% loading";
  parameter Real D(unit = "MW (pu)/elect rad") = X1 / Xt * cos(A1) "synchronosing co-efficient for 50% loading";
  parameter Real P(unit = "rad/sec") = (D * 39.27) ^ (1 / 2)"frequency of oscillation";
  parameter Modelica.SIunits.Frequency f11 = P / 6.28 "frequency of oscillation for 50% loading";
  parameter Real A2 = asin(0.8) "torque angle for 80% loading";
  parameter Real D1(unit = "MW (pu)/elect rad") = X1 / Xt * cos(A2) "synchronosing co-efficient for 80% loading";
  parameter Real P1(unit = "rad/sec") = (D1 * 39.27) ^ (1 / 2)"frequency of oscillation";
  parameter Modelica.SIunits.Frequency f12 = P1 / 6.28 "frequency of oscillation for 80% loading";
  //The answers may slightly vary due to rounding off values.   

  OpenIPSL.Electrical.Buses.Bus bus1 annotation(
    Placement(visible = true, transformation(origin = {-36, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {36, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-61, 0}, {-36, 0}}, color = {0, 0, 255}));
  connect(pwLine1.p, bus1.p) annotation(
    Line(points = {{-8, 0}, {-36, 0}}, color = {0, 0, 255}));
  connect(Generator1.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-106, 0}, {-83, 0}}, color = {0, 0, 255}));
  connect(Generator1.pm0, Generator1.pm) annotation(
    Line(points = {{-124, -11}, {-124, -11}, {-124, -19}, {-136, -19}, {-136, -7}, {-128, -7}, {-128, -5}}, color = {0, 0, 127}));
  connect(Generator1.vf0, Generator1.vf) annotation(
    Line(points = {{-124, 11}, {-124, 11}, {-124, 17}, {-136, 17}, {-136, 5}, {-128, 5}, {-128, 5}}, color = {0, 0, 127}));
  connect(bus2.p, twoWindingTransformer2.p) annotation(
    Line(points = {{36, 0}, {58, 0}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus2.p) annotation(
    Line(points = {{10, 0}, {36, 0}}, color = {0, 0, 255}));
  connect(infiniteBus1.p, twoWindingTransformer2.n) annotation(
    Line(points = {{110, 0}, {79, 0}}, color = {0, 0, 255}));

annotation(
    Diagram(coordinateSystem(extent = {{-150, -100}, {150, 100}})),
    Icon(coordinateSystem(extent = {{-150, -100}, {150, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex12_5;
