model Ex14_2
  parameter Modelica.SIunits.Voltage El_l = 440 "rms line to line alternating voltage";
  constant Real pi = 2 * Modelica.Math.asin(1.0)"this pi is considered as radian";
  parameter Modelica.SIunits.Voltage Vd0 = 3 * 2 ^ 0.5 / pi * El_l"avg direct voltage";
  parameter Real Alfa(unit = "degree") = 15 "delay angle";
  parameter Real Alfa11(unit = "rad") = pi / 180 * Alfa"delay angle";
  parameter Modelica.SIunits.Reactance Xc = 0.3 "leakage reactance";
  parameter Modelica.SIunits.Current Id = 220 "output current";
  parameter Modelica.SIunits.Resistance Rc = 3 * Xc / pi "equivalent commutation reistance";
  parameter Real cosinedelta = cos(Alfa11) - (Id * 2 * Rc / Vd0)"value of cos(delta)";
  parameter Real delta(unit = "degree") = 180 / pi * acos(cosinedelta) "extinction angle";
  parameter Real Meu(unit = "degree") = delta - Alfa "overlap angle";
  parameter Real delta11(unit = "rad") = pi / 180 * delta"extinction angle";
  parameter Modelica.SIunits.Voltage Vd = Vd0 / 2 * (cos(Alfa11) + cos(delta11)) "avg direct voltage";
//The answers may slightly vary due to rounding off values.
end Ex14_2;
