model Ex17_4
OpenIPSL.Electrical.Machines.PSAT.Order2 generator1 annotation(
    Placement(visible = true, transformation(origin = {-52, 54}, extent = {{-8, -8}, {8, 8}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator2 annotation(
    Placement(visible = true, transformation(origin = {56, 54}, extent = {{-8, -8}, {8, 8}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus1(P_0 = 0, Q_0 = 1,V_0 = 1, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-52, 0}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(P_0 = 0, Q_0 = 1,V_0 = 1, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {56, 0}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1 annotation(
    Placement(visible = true, transformation(origin = {2, -6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1 annotation(
    Placement(visible = true, transformation(origin = {-52, -26}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2 annotation(
    Placement(visible = true, transformation(origin = {56, -26}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));

parameter Real V1=1"initial value of bus1 voltage";
parameter Real V2=1"initial value of bus2 voltage";
parameter Real delta2(unit = "degree")=0"initial voltage angle of bus2";
parameter Real Y11=2"admittance of bus1";
parameter Real Y22=Y11"admittance of bus2";
parameter Real Y12=1"admittance of the line connecting bus1 and bus2";
parameter Real Y21=Y12"admittance of the line connecting bus1 and bus2";
parameter Real P1=-V1*V2*Y12*sin(delta2)"real power of bus1";
parameter Real P2=V1*V2*Y12*sin(delta2)"real power of bus2";
parameter Real Q1=Y11*(V1^2)-Y12*V1*V2*cos(delta2)"reactive power of bus1";
parameter Real Q2=Y22*(V2^2)-Y12*V1*V2*cos(delta2)"reactive power of bus2";
//in the above case if we obtain Jacobian matrix then it will be as follows
parameter Real [4,3]H={{-1,0,0},{1,0,0},{0,3,-1},{0,-1,3}}"Jacobian matrix";
//following expressions can be obtained by applying LSE
parameter Real del_p2"change in real power of bus2";
parameter Real del_p1"change in real power of bus1";
parameter Real del_Q1"change in reactive power of bus1";
parameter Real del_Q2"change in reactive power of bus2";
parameter Real del_delta2=del_p2-del_p1"estimation of the perturbations in the angle part of the state variable arround its chosen initial value";
parameter Real del_V1=0.78*del_Q2-0.26*del_Q1"estimation of the perturbations in the state variable arround its chosen initial value";
parameter Real del_V2=0.38*del_Q2+0.14*del_Q1"estimation of the perturbations in the state variable arround its chosen initial value";
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {-160, 59}, extent = {{-20, -19}, {20, 19}}, rotation = 0)));
equation
  connect(bus2.p, pwLine1.n) annotation(
    Line(points = {{56, 0}, {52, 0}, {52, -6}, {12, -6}}, color = {0, 0, 255}));
  connect(bus2.p, voltDependant2.p) annotation(
    Line(points = {{56, 0}, {56, -20}}, color = {0, 0, 255}));
  connect(generator2.p, bus2.p) annotation(
    Line(points = {{56, 46}, {56, 0}}, color = {0, 0, 255}));
  connect(generator2.vf, generator2.vf0) annotation(
    Line(points = {{60, 64}, {60, 64}, {60, 70}, {70, 70}, {70, 60}, {64, 60}, {64, 60}}, color = {0, 0, 127}));
  connect(generator2.pm, generator2.pm0) annotation(
    Line(points = {{52, 64}, {52, 64}, {52, 70}, {42, 70}, {42, 60}, {48, 60}, {48, 60}}, color = {0, 0, 127}));
  connect(generator1.vf, generator1.vf0) annotation(
    Line(points = {{-48, 64}, {-48, 64}, {-48, 70}, {-38, 70}, {-38, 60}, {-44, 60}, {-44, 60}}, color = {0, 0, 127}));
  connect(generator1.pm, generator1.pm0) annotation(
    Line(points = {{-56, 64}, {-56, 64}, {-56, 70}, {-66, 70}, {-66, 60}, {-60, 60}, {-60, 60}}, color = {0, 0, 127}));
  connect(generator1.p, bus1.p) annotation(
    Line(points = {{-52, 46}, {-52, 0}}, color = {0, 0, 255}));
  connect(bus1.p, voltDependant1.p) annotation(
    Line(points = {{-52, 0}, {-52, -20}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-52, 0}, {-48, 0}, {-48, -6}, {-6, -6}, {-6, -6}}, color = {0, 0, 255}));
annotation(
    Diagram(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}})),
    __OpenModelica_commandLineOptions = "");

end Ex17_4;
