model Ex2_5
parameter Modelica.SIunits.Frequency f=50"line frequency";
parameter Modelica.SIunits.Length L=15*1e3"length of transmission line";
parameter Modelica.SIunits.Distance Dan=4.5"distance of conductor a from conductor n";
parameter Modelica.SIunits.Distance Dbn=3"distance of conductor b from conductor n";
parameter Modelica.SIunits.Distance Dcn=1.5"distance of conductor c from conductor n";
parameter Modelica.SIunits.Radius r=0.39"radius of conductor";
parameter Modelica.SIunits.ComplexCurrent Ia=Complex(-30,50)"current of conductor a";
parameter Modelica.SIunits.ComplexCurrent Ib=Complex(-25,55)"current of conductor b";
parameter Modelica.SIunits.ComplexCurrent Ic=Complex(55,-105)"current of conductor c";
parameter Complex Lambda=((Ia*log(1/Dan))+(Ib*log(1/Dbn))+(Ic*log(1/Dcn)))"Flux linkage to neutral in Wb-T/m";
parameter Real Lambda_abs(unit = "Wb-T/m")=(Lambda.re ^ 2 + Lambda.im ^ 2) ^ 0.5"absolute value of flux linkage";
parameter Complex V=Complex(0,314*L*2*1e-7)"a complex value";
parameter Real V_abs=(V.re ^ 2 + V.im ^ 2) ^ 0.5"absolute value of V";
parameter Modelica.SIunits.Voltage Vn=V_abs*Lambda_abs"voltage induced in neutral wire";
parameter Modelica.SIunits.ComplexVoltage delVa=V*((log((300)/r)*Ia)+(log(2)*Ib))"voltage drop of phase a";
//The answer may slightly vary due to rounding off values.
end Ex2_5;
