model Ex3_2
parameter Modelica.SIunits.Frequency f=50"line frequency";
parameter Real n=7"no.of strand";
parameter Modelica.SIunits.Distance D12=3.5"distance of conductor1 from conductor2";
parameter Modelica.SIunits.Distance D21=D12"distance of conductor2 from conductor1";
parameter Real Do(final quantity="Diameter", final unit="cm")=1.05"outside diameter";
parameter Real r(final quantity="Radius", final unit="cm")=Do/2"outside radius";
parameter Real V(final quantity="ElectricPotential", final unit="kV")=110"line voltage";
parameter Real Vn(final quantity="ElectricPotential", final unit="kV")=V/(3^0.5)"phase voltage";
parameter Modelica.SIunits.Distance Deq=(D12*D21*n)^(1/3)"equivalent equilateral spacing";
parameter Real Cn(final quantity="Capacitance",final unit="microF/km")=0.0242/(log10((Deq*100)/r))"capacitance to neutral";
parameter Real Xn(final quantity="CapacitiveReactance",final unit="Ohms/km")=1e6/(314*Cn)"Capacitive reactance to neutral";
parameter Modelica.SIunits.Current Cc=(Vn/Xn)*1000"charging current/km";
//The answers may slightly vary due to rounding off values.
end Ex3_2;
