model Ex3_5
parameter Modelica.SIunits.Frequency f=50"line frequency";
constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Modelica.SIunits.Permittivity epsa=8.854e-12"permittivity of free space";
parameter Real n=7"no.of strand";
parameter Modelica.SIunits.Distance D12=3.5"spacing between two conductors";
parameter Modelica.SIunits.Distance D21=D12"spacing between two conductors";
parameter Modelica.SIunits.Diameter Do=1.05"outside diameter";
parameter Real V(final quantity="ElectricPotential", final unit="kV")=110"voltage of 3-phase transmission line";
parameter Real Vn(final quantity="ElectricPotential", final unit="kV")=(V*1000)/(3^0.5)"voltage of 3-phase transmission line to neutral";
parameter Modelica.SIunits.Radius r=(Do*1e-2)/2"outside radius";
parameter Modelica.SIunits.Distance Deq=(D12*D21*n)^(1/3)"the equivalent spacing";
parameter Modelica.SIunits.Capacitance Cn=(2*pi*epsa)/log(Deq/r)"capacitance of line to neutral /m";
parameter Modelica.SIunits.Capacitance Cn1=Cn*1000"capacitance of line to neutral /km";
parameter Real Xc(final quantity="CapacitiveReactance",final unit="Ohms/km")=1/(2*pi*f*Cn1)"capacitive reactance to neutral";
parameter Modelica.SIunits.Current Ic=(Vn/Xc)"charging current /km";
parameter Modelica.SIunits.ReactivePower V_r=((V*1000)^2)/Xc"reactive volt amperes generated by the line";
//The answers may slightly vary due to rounding off values.
end Ex3_5;
