model Ex5_1
parameter Modelica.SIunits.Frequency f=50"line frequency";
parameter Modelica.SIunits.Resistance R=0.0195"line resistance/km";
parameter Real X(final quantity="Inductance",final unit="mH")=0.63"line inductance /km";
parameter Real load(final quantity="Power", final unit="kW")=5000"inductive load of generator";
parameter Real length(final quantity="Length", final unit="km")=20"lenght of over head transmission line";
parameter Real pf=0.707"receiving end power factor";
parameter Real V_r(final quantity="ElectricPotential", final unit="kV")=10"voltage at the receiving end of line";
parameter Real w=314"a constant value";
parameter Real sinfi=0.412"reactive power factor";
parameter Modelica.SIunits.Resistance R1=R*length"line constant resistance";
parameter Modelica.SIunits.Resistance X1=X*1e-3*w*length"line constant inductance";
//case1
parameter Modelica.SIunits.Current I=load/(V_r*pf)"line current";
parameter Real Vs(final quantity="ElectricPotential", final unit="kV")=((V_r*1e3)+I*((R1*pf)+(X1*pf)))/1e3"sending end voltage of the line";
parameter Real V_reg(unit="%")=((Vs-V_r)/V_r)*100"voltage regulation of line";
//case2
parameter Real V_reg_req(unit="%")=V_reg/2"desired voltage regulation";
parameter Real Vs_new(final quantity="ElectricPotential", final unit="kV")=((V_reg_req/1e2)*V_r)+V_r"new value of sending end voltage";
parameter Real cosfi=(load*X1*sinfi)/(((Vs_new-V_r)*(1e3*V_r))-(load*R1))"improved receiving end power factor of load and capacitive reactance taken together";
parameter Modelica.SIunits.Current Ir=load/(cosfi*V_r)"reduced current flows";
parameter Modelica.SIunits.ComplexCurrent Ir_ac=Complex(cosfi,-sinfi)"complex representation of reduced current flows";
parameter Modelica.SIunits.ComplexCurrent I_ac=Complex(pf,-pf)"complex representation of line current";
parameter Modelica.SIunits.ComplexCurrent Ic=(Ir*Ir_ac)-(I*I_ac)"current passes through capacitor";
parameter Modelica.SIunits.ComplexCurrent Ic1=Complex(0,Ic.im)"real part is neglected of current passes through capacitor";
parameter Modelica.SIunits.Reactance Xc=(V_r*1e3)/Ic1.im"capacitive reactance";
parameter Real c(final quantity="Capacitance",final unit="microF")=(1/(w*Xc))*1e6"required value of capacitor";
//case3
parameter Real n_a(final quantity="Efficiency",final unit="%")=(load/(load+((I^2)*(R1*1e-3))))*100"efficiency of transmission of case a";
parameter Real n_b(final quantity="Efficiency",final unit="%")=(load/(load+((Ir^2)*(R1*1e-3))))*100"efficiency of transmission of case b";
//The answers may slightly vary due to rounding off values.
end Ex5_1;
