model Ex5_12
constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979 in radian;
parameter Real R2D = 180 / pi"Radian to degree conversion";
parameter Real D2R = pi / 180"Degree to radian conversion";
parameter Real del_AB=240"power angle in degree,it is  random value, one can also use another value of it";
parameter Complex Ys=Complex(0,-1.8)"series admittance in pu";
parameter Complex Yp=Complex(0,0.0004)"shunt admittance in pu";
parameter Real Ea(unit = "pu")=1"voltage operating at delta1";
parameter Complex Y_AA=Yp+Ys"short circuit driving point admittance in pu";
parameter Real Y_AA_abs(unit = "pu") = (Y_AA.re ^ 2 + Y_AA.im ^ 2) ^ 0.5"absolute value of short circuit driving point admittance";
parameter Real Y_AA_arg(unit="degree")=-90"angle of short circuit driving point admittance as Y_AA is negative";
parameter Complex Y_AB=-Ys"transfer admittance in pu";
parameter Real Y_AB_abs(unit = "pu") = (Y_AB.re ^ 2 + Y_AB.im ^ 2) ^ 0.5"absolute value of transfer admittance";
parameter Real Y_AB_arg(unit="degree")=90"angle of transfer admittance as Y_AB is positive";
parameter Real theta_AB(unit="degree")=90-Y_AB_arg"angle thetaAB";
parameter Real theta_AA(unit="degree")=90-Y_AA_arg"angle thetaAA";
parameter Real Y_BB(unit = "pu")=Y_AA_abs"short circuit driving point admittance";
parameter Real Y_BA(unit = "pu")=Y_AB_abs"transfer admittance";
parameter Real theta_BB(unit="degree")=theta_AA"angle thetaBB";
parameter Real theta_BA(unit="degree")=theta_AB"angle thetaBA";
parameter Real Eb(unit = "pu")=Ea"voltage operating at delta2";
parameter Real P1(unit = "pu")=((Ea^2)*Y_AA_abs*sin(theta_AA*D2R))+(Ea*Eb*Y_AB_abs*sin((del_AB-theta_AB)*D2R))"real power of A";
parameter Real P2(unit = "pu")=((-Eb^2)*Y_BB*sin(theta_BB*D2R))+(Ea*Eb*Y_AB_abs*sin((del_AB+theta_AB)*D2R))"real power of B";
parameter Real Q1(unit = "pu")=((Ea^2)*Y_AA_abs*cos(theta_AA*D2R))-(Ea*Eb*Y_AB_abs*cos((del_AB-theta_AB)*D2R))"reactive power of A";
parameter Real Q2(unit = "pu")=((-Eb^2)*Y_BB*cos(theta_BB*D2R))+(Ea*Eb*Y_AB_abs*cos((del_AB+theta_AB)*D2R))"reactive power of B";
//The answers may slightly vary due to rounding off values.
end Ex5_12;
